/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidContainerItem;

public class FluidUtil {
    private static boolean oldFluidIDMethod = true;
    private static Class<?> fluidStackClass = null;
    private static Method getFluidMethod = null;
    private static Field fluidIdField = null;

    public static boolean isFuelContainerAny(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77973_b() == GCItems.fuelCanister && var4.func_77960_j() < var4.func_77958_k();
        }
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)var4);
        return liquid != null && FluidUtil.testFuel(FluidRegistry.getFluidName((FluidStack)liquid));
    }

    public static boolean testFuel(String name) {
        if (name.startsWith("fuel")) {
            return true;
        }
        if (name.contains("rocket") && name.contains("fuel")) {
            return true;
        }
        return name.equals("rc jet fuel");
    }

    public static int fillWithGCFuel(FluidTank tank, FluidStack liquid, boolean doFill) {
        if (liquid != null && FluidUtil.testFuel(FluidRegistry.getFluidName((FluidStack)liquid))) {
            FluidStack liquidInTank = tank.getFluid();
            if (liquidInTank == null) {
                return tank.fill(new FluidStack(GalacticraftCore.fluidFuel, liquid.amount), doFill);
            }
            if (liquidInTank.amount < tank.getCapacity()) {
                return tank.fill(new FluidStack(liquidInTank, liquid.amount), doFill);
            }
        }
        return 0;
    }

    public static boolean isOilContainerAny(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77973_b() == GCItems.oilCanister && var4.func_77960_j() < var4.func_77958_k();
        }
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)var4);
        return liquid != null && FluidRegistry.getFluidName((FluidStack)liquid).startsWith("oil");
    }

    public static boolean isMethaneContainerAny(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77973_b() == AsteroidsItems.methaneCanister && var4.func_77960_j() < var4.func_77958_k();
        }
        FluidStack stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)var4);
        return stack != null && stack.getFluid() != null && stack.getFluid().getName().toLowerCase().contains("methane");
    }

    public static boolean isFullContainer(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77960_j() == 1;
        }
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)var4);
        return liquid != null;
    }

    public static void tryFillContainer(FluidTank tank, FluidStack liquid, ItemStack[] inventory, int slot, Item canisterType) {
        ItemStack slotItem = inventory[slot];
        boolean isCanister = slotItem.func_77973_b() instanceof ItemCanisterGeneric;
        int amountToFill = Math.min(liquid.amount, isCanister ? slotItem.func_77960_j() - 1 : 1000);
        if (amountToFill <= 0 || isCanister && slotItem.func_77973_b() != canisterType && slotItem.func_77960_j() != 1001) {
            return;
        }
        if (isCanister) {
            inventory[slot] = new ItemStack(canisterType, 1, slotItem.func_77960_j() - amountToFill);
            tank.drain(amountToFill, true);
        } else if (amountToFill == 1000) {
            inventory[slot] = FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)inventory[slot]);
            if (inventory[slot] == null) {
                inventory[slot] = slotItem;
            } else {
                tank.drain(amountToFill, true);
            }
        }
    }

    public static void tryFillContainerFuel(FluidTank tank, ItemStack[] inventory, int slot) {
        String liquidname;
        FluidStack liquid;
        if (FluidUtil.isValidContainer(inventory[slot]) && (liquid = tank.getFluid()) != null && liquid.amount > 0 && (liquidname = liquid.getFluid().getName()).startsWith("fuel")) {
            FluidStack existingFluid;
            ItemStack stack;
            if (!liquidname.equals(GalacticraftCore.fluidFuel.getName())) {
                liquid = new FluidStack(GalacticraftCore.fluidFuel, liquid.amount);
            }
            if ((stack = inventory[slot]).func_77973_b() instanceof IFluidContainerItem && (existingFluid = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack)) != null && !existingFluid.getFluid().getName().equals(GalacticraftCore.fluidFuel.getName())) {
                liquid = new FluidStack(existingFluid, liquid.amount);
            }
            FluidUtil.tryFillContainer(tank, liquid, inventory, slot, GCItems.fuelCanister);
        }
    }

    public static boolean isEmptyContainer(ItemStack var4, Item canisterType) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77960_j() == 1001 || var4.func_77973_b() == canisterType && var4.func_77960_j() > 1;
        }
        return FluidContainerRegistry.isEmptyContainer((ItemStack)var4);
    }

    public static boolean isEmptyContainerFor(ItemStack var4, FluidStack targetFluid) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            if (var4.func_77960_j() == 1001) {
                return true;
            }
            if (var4.func_77960_j() == 1) {
                return false;
            }
            return FluidUtil.fluidsSame(((ItemCanisterGeneric)var4.func_77973_b()).getFluid(var4), targetFluid);
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)var4)) {
            return true;
        }
        return FluidUtil.fluidsSame(FluidContainerRegistry.getFluidForFilledItem((ItemStack)var4), targetFluid);
    }

    public static boolean fluidsSame(FluidStack fs1, FluidStack fs2) {
        if (fs1 == null || fs2 == null) {
            return false;
        }
        Fluid f1 = fs1.getFluid();
        Fluid f2 = fs2.getFluid();
        if (f1 == null || f2 == null || f1.getName() == null) {
            return false;
        }
        return f1.getName().equals(f2.getName());
    }

    public static boolean isEmptyContainer(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77960_j() == 1001;
        }
        return FluidContainerRegistry.isEmptyContainer((ItemStack)var4);
    }

    public static boolean isEmptyGasContainer(ItemStack var4) {
        return false;
    }

    public static boolean isFilledContainer(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77960_j() < 1001;
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)var4) != null;
    }

    public static boolean isWaterContainer(ItemStack var4) {
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)var4);
        return liquid != null && liquid.getFluid() != null && liquid.getFluid().getName().equals("water");
    }

    public static boolean isValidContainer(ItemStack slotItem) {
        return slotItem != null && slotItem.field_77994_a == 1 && (slotItem.func_77973_b() instanceof ItemCanisterGeneric || FluidContainerRegistry.isContainer((ItemStack)slotItem));
    }

    public static ItemStack getUsedContainer(ItemStack container) {
        if (FluidContainerRegistry.isBucket((ItemStack)container) && FluidContainerRegistry.isFilledContainer((ItemStack)container)) {
            return new ItemStack(Items.field_151133_ar, container.field_77994_a);
        }
        --container.field_77994_a;
        if (container.field_77994_a == 0) {
            return null;
        }
        return container;
    }

    public static int getFluidID(FluidStack stack) {
        block9: {
            try {
                if (oldFluidIDMethod) {
                    try {
                        if (getFluidMethod == null) {
                            if (fluidStackClass == null) {
                                fluidStackClass = Class.forName("net.minecraftforge.fluids.FluidStack");
                            }
                            getFluidMethod = fluidStackClass.getDeclaredMethod("getFluidID", new Class[0]);
                        }
                        return (Integer)getFluidMethod.invoke((Object)stack, new Object[0]);
                    }
                    catch (NoSuchMethodException error) {
                        oldFluidIDMethod = false;
                        FluidUtil.getFluidID(stack);
                        break block9;
                    }
                }
                if (fluidIdField == null) {
                    if (fluidStackClass == null) {
                        fluidStackClass = Class.forName("net.minecraftforge.fluids.FluidStack");
                    }
                    fluidIdField = fluidStackClass.getDeclaredField("fluidID");
                }
                return fluidIdField.getInt(stack);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }
}

