/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.vec;

import cofh.repack.codechicken.lib.vec.Matrix4;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;

public class TransformationList
extends Transformation {
    private ArrayList<Transformation> transformations = new ArrayList();
    private Matrix4 mat;

    public TransformationList(Transformation ... transformationArray) {
        for (Transformation transformation : transformationArray) {
            if (transformation instanceof TransformationList) {
                this.transformations.addAll(((TransformationList)transformation).transformations);
                continue;
            }
            this.transformations.add(transformation);
        }
        this.compact();
    }

    public Matrix4 compile() {
        if (this.mat == null) {
            this.mat = new Matrix4();
            for (int i = this.transformations.size() - 1; i >= 0; --i) {
                this.transformations.get(i).apply(this.mat);
            }
        }
        return this.mat;
    }

    public Matrix4 reverseCompile() {
        Matrix4 matrix4 = new Matrix4();
        for (Transformation transformation : this.transformations) {
            transformation.apply(matrix4);
        }
        return matrix4;
    }

    @Override
    public void apply(Vector3 vector3) {
        if (this.mat != null) {
            this.mat.apply(vector3);
        } else {
            for (int i = 0; i < this.transformations.size(); ++i) {
                this.transformations.get(i).apply(vector3);
            }
        }
    }

    @Override
    public void applyN(Vector3 vector3) {
        if (this.mat != null) {
            this.mat.applyN(vector3);
        } else {
            for (int i = 0; i < this.transformations.size(); ++i) {
                this.transformations.get(i).applyN(vector3);
            }
        }
    }

    @Override
    public void apply(Matrix4 matrix4) {
        matrix4.multiply(this.compile());
    }

    @Override
    public TransformationList with(Transformation transformation) {
        if (transformation.isRedundant()) {
            return this;
        }
        this.mat = null;
        if (transformation instanceof TransformationList) {
            this.transformations.addAll(((TransformationList)transformation).transformations);
        } else {
            this.transformations.add(transformation);
        }
        this.compact();
        return this;
    }

    public TransformationList prepend(Transformation transformation) {
        if (transformation.isRedundant()) {
            return this;
        }
        this.mat = null;
        if (transformation instanceof TransformationList) {
            this.transformations.addAll(0, ((TransformationList)transformation).transformations);
        } else {
            this.transformations.add(0, transformation);
        }
        this.compact();
        return this;
    }

    private void compact() {
        ArrayList<Transformation> arrayList = new ArrayList<Transformation>(this.transformations.size());
        Iterator<Transformation> iterator = this.transformations.iterator();
        Transformation transformation = null;
        while (iterator.hasNext()) {
            Transformation transformation2 = iterator.next();
            if (transformation2.isRedundant()) continue;
            if (transformation != null) {
                Transformation transformation3 = transformation.merge(transformation2);
                if (transformation3 == null) {
                    arrayList.add(transformation);
                } else {
                    transformation2 = transformation3.isRedundant() ? null : transformation3;
                }
            }
            transformation = transformation2;
        }
        if (transformation != null) {
            arrayList.add(transformation);
        }
        if (arrayList.size() < this.transformations.size()) {
            this.transformations = arrayList;
            this.mat = null;
        }
        if (this.transformations.size() > 3 && this.mat == null) {
            this.compile();
        }
    }

    @Override
    public boolean isRedundant() {
        return this.transformations.size() == 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void glApply() {
        for (int i = this.transformations.size() - 1; i >= 0; --i) {
            this.transformations.get(i).glApply();
        }
    }

    @Override
    public Transformation inverse() {
        TransformationList transformationList = new TransformationList(new Transformation[0]);
        for (int i = this.transformations.size() - 1; i >= 0; --i) {
            transformationList.with((Transformation)this.transformations.get(i).inverse());
        }
        return transformationList;
    }

    public String toString() {
        String string = "";
        for (Transformation transformation : this.transformations) {
            string = string + "\n" + transformation.toString();
        }
        return string.trim();
    }
}

