/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.api;

import com.theoriginalbit.moarperipherals.api.bitnet.IBitNetCompliant;
import java.lang.reflect.Method;

public class MoarPeripheralsAPI {
    private static boolean searched = false;
    private static Class<?> bitNetRegistry;
    private static Method bitNetRegisterCompliance;
    private static Method bitNetDeregisterCompliance;
    private static Method bitNetTransmit;

    public static void registerBitNetCompliance(IBitNetCompliant tile) {
        MoarPeripheralsAPI.findBitNet();
        try {
            bitNetRegisterCompliance.invoke(null, tile);
        }
        catch (Exception e) {
            System.out.println("MoarPeripheralsAPI: Failed to register BitNet compliant TileEntity");
        }
    }

    public static void deregisterBitNetCompliance(IBitNetCompliant tile) {
        MoarPeripheralsAPI.findBitNet();
        try {
            bitNetDeregisterCompliance.invoke(null, tile);
        }
        catch (Exception e) {
            System.out.println("MoarPeripheralsAPI: Failed to register BitNet compliant TileEntity");
        }
    }

    public static void sendBitNetMessage(IBitNetCompliant tile, Object payload) {
        MoarPeripheralsAPI.findBitNet();
        try {
            bitNetTransmit.invoke(null, tile, payload);
        }
        catch (Exception e) {
            System.out.println("MoarPeripheralsAPI: Failed to transmit message via BitNet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findBitNet() {
        if (!searched) {
            try {
                bitNetRegistry = Class.forName("com.theoriginalbit.moarperipherals.common.registry.BitNetRegistry");
                bitNetRegisterCompliance = MoarPeripheralsAPI.findBitNetMethod("registerCompliance", new Class[]{IBitNetCompliant.class});
                bitNetDeregisterCompliance = MoarPeripheralsAPI.findBitNetMethod("deregisterCompliance", new Class[]{IBitNetCompliant.class});
                bitNetTransmit = MoarPeripheralsAPI.findBitNetMethod("transmit", new Class[]{IBitNetCompliant.class, Object.class});
            }
            catch (Exception e) {
                System.err.println("MoarPeripheralsAPI: BitNetRegistry not found.");
            }
            finally {
                searched = true;
            }
        }
    }

    private static Method findBitNetMethod(String name, Class[] args) {
        try {
            return bitNetRegistry.getMethod(name, args);
        }
        catch (Exception e) {
            System.err.println("MoarPeripheralsAPI: BitNet Method " + name + " not found.");
            return null;
        }
    }
}

