/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.api.bitnet;

import java.util.UUID;

public class BitNetMessage {
    private final UUID messageId;
    private final Object payload;
    private double distanceTravelled = 0.0;

    public BitNetMessage(Object message) {
        this.messageId = UUID.randomUUID();
        this.payload = message;
    }

    public BitNetMessage(BitNetMessage other) {
        this.messageId = other.getMessageId();
        this.payload = other.getPayload();
        this.distanceTravelled = other.getDistanceTravelled();
    }

    public UUID getMessageId() {
        return this.messageId;
    }

    public Object getPayload() {
        return this.payload;
    }

    public double getDistanceTravelled() {
        return this.distanceTravelled;
    }

    public BitNetMessage addDistance(double dist) {
        this.distanceTravelled += dist;
        return this;
    }

    public String toString() {
        return String.format("{type=BitNet Message, id=#%s payload=%s}", this.messageId, this.payload);
    }
}

