/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.api.peripheral;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.theoriginalbit.moarperipherals.api.peripheral.converter.ConverterArray;
import com.theoriginalbit.moarperipherals.api.peripheral.converter.ConverterDefault;
import com.theoriginalbit.moarperipherals.api.peripheral.converter.ConverterList;
import com.theoriginalbit.moarperipherals.api.peripheral.converter.ConverterMap;
import com.theoriginalbit.moarperipherals.api.peripheral.converter.ConverterNumber;
import com.theoriginalbit.moarperipherals.api.peripheral.converter.ConverterSet;
import com.theoriginalbit.moarperipherals.api.peripheral.converter.ConverterString;
import com.theoriginalbit.moarperipherals.api.peripheral.converter.ITypeConverter;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.LuaException;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LuaType {
    private static final Deque<ITypeConverter> CONVERTERS = Lists.newLinkedList();
    private static final HashMap<Class<?>, String> CLASS_TO_NAME = Maps.newHashMap();

    public static void registerTypeConverter(ITypeConverter converter) {
        if (!CONVERTERS.contains(converter)) {
            CONVERTERS.addFirst(converter);
        }
    }

    public static void registerClassToNameMapping(Class<?> clazz, String name) {
        if (!CLASS_TO_NAME.containsKey(clazz) && !CLASS_TO_NAME.containsValue(name)) {
            CLASS_TO_NAME.put(clazz, name);
        }
    }

    public static String getLuaName(Class<?> clazz) {
        if (clazz == null) {
            return "nil";
        }
        if (CLASS_TO_NAME.containsKey(clazz)) {
            return CLASS_TO_NAME.get(clazz);
        }
        for (Map.Entry<Class<?>, String> entry : CLASS_TO_NAME.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz) && !clazz.isAssignableFrom(entry.getKey())) continue;
            return entry.getValue();
        }
        return "?";
    }

    public static Object fromLua(Object obj, Class<?> expected) throws LuaException {
        if (expected == Object.class) {
            return obj;
        }
        for (ITypeConverter converter : CONVERTERS) {
            Object response = converter.fromLua(obj, expected);
            if (response == null) continue;
            return response;
        }
        return null;
    }

    public static Object toLua(Object obj) throws LuaException {
        if (obj == null || obj instanceof ILuaObject) {
            return obj;
        }
        for (ITypeConverter converter : CONVERTERS) {
            Object response = converter.toLua(obj);
            if (response == null) continue;
            return response;
        }
        throw new IllegalStateException("Conversion failed on " + obj);
    }

    static {
        CLASS_TO_NAME.put(Object[].class, "table");
        CLASS_TO_NAME.put(Map.class, "table");
        CLASS_TO_NAME.put(List.class, "table");
        CLASS_TO_NAME.put(Set.class, "table");
        CLASS_TO_NAME.put(Number.class, "number");
        CLASS_TO_NAME.put(Integer.TYPE, "number");
        CLASS_TO_NAME.put(Long.TYPE, "number");
        CLASS_TO_NAME.put(Short.TYPE, "number");
        CLASS_TO_NAME.put(Byte.TYPE, "number");
        CLASS_TO_NAME.put(Double.TYPE, "number");
        CLASS_TO_NAME.put(Float.TYPE, "number");
        CLASS_TO_NAME.put(String.class, "string");
        CLASS_TO_NAME.put(Void.class, "nil");
        CLASS_TO_NAME.put(Boolean.class, "boolean");
        CLASS_TO_NAME.put(Boolean.TYPE, "boolean");
        CLASS_TO_NAME.put(Void.class, "nil");
        CLASS_TO_NAME.put(Void.TYPE, "nil");
        CLASS_TO_NAME.put(Object.class, "?");
        CONVERTERS.add(new ConverterArray());
        CONVERTERS.add(new ConverterList());
        CONVERTERS.add(new ConverterMap());
        CONVERTERS.add(new ConverterSet());
        CONVERTERS.add(new ConverterDefault());
        CONVERTERS.add(new ConverterNumber());
        CONVERTERS.add(new ConverterString());
    }
}

