/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.api.peripheral;

import com.google.common.base.Preconditions;
import com.theoriginalbit.moarperipherals.api.peripheral.ILuaPeripheralProvider;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.LuaPeripheral;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.Requires;
import com.theoriginalbit.moarperipherals.api.peripheral.wrapper.WrapperComputer;
import cpw.mods.fml.common.Loader;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.WeakHashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public final class PeripheralProvider
implements IPeripheralProvider {
    private final WeakHashMap<TileEntity, WrapperComputer> PERIPHERAL_CACHE = new WeakHashMap();

    public final IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile.func_145837_r()) {
            return null;
        }
        if (this.PERIPHERAL_CACHE.containsKey(tile)) {
            return this.PERIPHERAL_CACHE.get(tile);
        }
        WrapperComputer wrapper = null;
        if (tile instanceof ILuaPeripheralProvider) {
            Preconditions.checkArgument((!PeripheralProvider.isLuaPeripheral(tile) ? 1 : 0) != 0, (Object)"Peripherals cannot implement ILuaPeripheralProvider and have the LuaPeripheral annotation present");
            Object peripheral = ((ILuaPeripheralProvider)tile).getPeripheral();
            Preconditions.checkArgument((boolean)PeripheralProvider.isLuaPeripheral(peripheral), (Object)"The peripheral returned from the ILuaPeripheralProvider was not annotated with LuaPeripheral");
            if (PeripheralProvider.isEnabledLuaPeripheral(peripheral)) {
                wrapper = new WrapperComputer(peripheral);
            }
        } else if (PeripheralProvider.isEnabledLuaPeripheral(tile)) {
            wrapper = new WrapperComputer(tile);
        }
        if (wrapper != null) {
            this.PERIPHERAL_CACHE.put(tile, wrapper);
            return wrapper;
        }
        return null;
    }

    private static boolean isLuaPeripheral(Object peripheral) {
        return peripheral.getClass().isAnnotationPresent(LuaPeripheral.class);
    }

    private static boolean isEnabledLuaPeripheral(Object peripheral) {
        Class<?> clazz = peripheral.getClass();
        if (!clazz.isAnnotationPresent(LuaPeripheral.class)) {
            return false;
        }
        if (!clazz.isAnnotationPresent(Requires.class)) {
            return true;
        }
        Requires requires = clazz.getAnnotation(Requires.class);
        String[] modIds = requires.modIds();
        boolean allRequired = requires.allRequired();
        for (String mid : modIds) {
            boolean loaded = Loader.isModLoaded((String)mid);
            if (loaded && !allRequired) {
                return true;
            }
            if (loaded || !allRequired) continue;
            return false;
        }
        return true;
    }
}

