/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.api.peripheral.converter;

import com.google.common.collect.Maps;
import com.theoriginalbit.moarperipherals.api.peripheral.LuaType;
import com.theoriginalbit.moarperipherals.api.peripheral.converter.ITypeConverter;
import dan200.computercraft.api.lua.LuaException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class ConverterArray
implements ITypeConverter {
    @Override
    public Object fromLua(Object obj, Class<?> expected) throws LuaException {
        if (obj instanceof Map && expected.isArray()) {
            int index;
            Map map = (Map)obj;
            Class<?> component = expected.getComponentType();
            if (map.isEmpty()) {
                return Array.newInstance(component, 0);
            }
            int indexMin = Integer.MAX_VALUE;
            int indexMax = Integer.MIN_VALUE;
            HashMap tmp = Maps.newHashMap();
            for (Map.Entry e : map.entrySet()) {
                Object k = e.getKey();
                if (!(k instanceof Number)) {
                    return null;
                }
                index = ((Number)k).intValue();
                if (index < indexMin) {
                    indexMin = index;
                }
                if (index > indexMax) {
                    indexMax = index;
                }
                tmp.put(index, e.getValue());
            }
            int size = indexMax - indexMin + 1;
            if (size != tmp.size() || indexMin != 0 && indexMin != 1) {
                return null;
            }
            Object result = Array.newInstance(component, size);
            int i = 0;
            index = indexMin;
            while (i < size) {
                Object in = tmp.get(index);
                Object out = LuaType.fromLua(in, component);
                if (out == null) {
                    return null;
                }
                Array.set(result, i, out);
                ++i;
                ++index;
            }
            return result;
        }
        return null;
    }

    @Override
    public Object toLua(Object obj) throws LuaException {
        if (obj.getClass().isArray()) {
            HashMap map = Maps.newHashMap();
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                map.put(i + 1, LuaType.toLua(Array.get(obj, i)));
            }
            return map;
        }
        return null;
    }
}

