/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.api.peripheral.converter;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.theoriginalbit.moarperipherals.api.peripheral.converter.ITypeConverter;

public class ConverterDefault
implements ITypeConverter {
    private static final BiMap<Class<?>, Class<?>> WRAPPERS = ImmutableBiMap.builder().put(Long.TYPE, Long.class).put(Integer.TYPE, Integer.class).put(Short.TYPE, Short.class).put(Byte.TYPE, Byte.class).put(Boolean.TYPE, Boolean.class).put(Double.TYPE, Double.class).put(Float.TYPE, Float.class).put(Character.TYPE, Character.class).build();

    @Override
    public Object fromLua(Object obj, Class<?> expected) {
        if (ConverterDefault.compareTypes(obj.getClass(), expected)) {
            return obj;
        }
        return null;
    }

    @Override
    public Object toLua(Object obj) {
        if (obj instanceof Boolean) {
            return obj;
        }
        return null;
    }

    private static boolean compareTypes(Class<?> left, Class<?> right) {
        if (left.isPrimitive()) {
            left = (Class)WRAPPERS.get(left);
        }
        if (right.isPrimitive()) {
            right = (Class)WRAPPERS.get(right);
        }
        return left.equals(right);
    }
}

