/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.api.peripheral.converter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.theoriginalbit.moarperipherals.api.peripheral.LuaType;
import com.theoriginalbit.moarperipherals.api.peripheral.converter.ITypeConverter;
import dan200.computercraft.api.lua.LuaException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConverterList
implements ITypeConverter {
    @Override
    public Object fromLua(Object obj, Class<?> expected) throws LuaException {
        if (obj instanceof Map && expected == List.class) {
            Map map = (Map)obj;
            if (map.isEmpty()) {
                return ImmutableList.of();
            }
            int indexMin = Integer.MAX_VALUE;
            int indexMax = Integer.MIN_VALUE;
            HashMap tmp = Maps.newHashMap();
            for (Map.Entry e : map.entrySet()) {
                Object k = e.getKey();
                if (!(k instanceof Number)) {
                    return null;
                }
                int index = ((Number)k).intValue();
                if (index < indexMin) {
                    indexMin = index;
                }
                if (index > indexMax) {
                    indexMax = index;
                }
                tmp.put(index, e.getValue());
            }
            int size = indexMax - indexMin + 1;
            if (size != tmp.size() || indexMin != 0 && indexMin != 1) {
                return null;
            }
            ArrayList result = Lists.newArrayList();
            for (int index = indexMin; index <= indexMax; ++index) {
                Object o = tmp.get(index);
                result.add(o);
            }
            return result;
        }
        return null;
    }

    @Override
    public Object toLua(Object obj) throws LuaException {
        if (obj instanceof List) {
            HashMap map = Maps.newHashMap();
            List objList = (List)obj;
            for (int i = 0; i < objList.size(); ++i) {
                map.put(i + 1, LuaType.toLua(objList.get(i)));
            }
            return map;
        }
        return null;
    }
}

