/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.api.peripheral.turtle;

import com.theoriginalbit.moarperipherals.api.peripheral.wrapper.WrapperComputer;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import net.minecraft.item.ItemStack;

public abstract class UpgradePeripheral
implements ITurtleUpgrade {
    private final int id;
    private final String name;
    private final ItemStack stack;

    public UpgradePeripheral(int upgradeId, String adjective, ItemStack craftingItemStack) {
        this.id = upgradeId;
        this.name = adjective;
        this.stack = craftingItemStack;
    }

    public final int getUpgradeID() {
        return this.id;
    }

    public final String getUnlocalisedAdjective() {
        return this.name;
    }

    public final TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    public final ItemStack getCraftingItem() {
        return this.stack;
    }

    public final IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        try {
            WrapperComputer wrapper = this.getPeripheralWrapper(turtle, side);
            this.update(turtle, side, wrapper);
            return wrapper;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public final TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        return TurtleCommandResult.failure();
    }

    public final void update(ITurtleAccess turtle, TurtleSide side) {
        IPeripheral peripheral = turtle.getPeripheral(side);
        if (peripheral instanceof WrapperComputer) {
            this.update(turtle, side, (WrapperComputer)peripheral);
        }
    }

    protected abstract void update(ITurtleAccess var1, TurtleSide var2, WrapperComputer var3);

    protected abstract WrapperComputer getPeripheralWrapper(ITurtleAccess var1, TurtleSide var2);
}

