/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.api.peripheral.turtle;

import com.theoriginalbit.moarperipherals.api.peripheral.exception.TurtleFailureAttack;
import com.theoriginalbit.moarperipherals.api.peripheral.exception.TurtleFailureDig;
import com.theoriginalbit.moarperipherals.api.peripheral.turtle.PlayerTurtle;
import com.theoriginalbit.moarperipherals.common.utils.InventoryUtils;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Facing;
import net.minecraft.world.World;

public abstract class UpgradeTool
implements ITurtleUpgrade {
    private final int id;
    private final String name;
    protected final ItemStack craftingStack;

    protected UpgradeTool(int upgradeId, String adjective, ItemStack craftingItemStack) {
        this.id = upgradeId;
        this.name = adjective;
        this.craftingStack = craftingItemStack;
    }

    public final int getUpgradeID() {
        return this.id;
    }

    public final String getUnlocalisedAdjective() {
        return this.name;
    }

    public final TurtleUpgradeType getType() {
        return TurtleUpgradeType.Tool;
    }

    public final ItemStack getCraftingItem() {
        return this.craftingStack;
    }

    public final IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return null;
    }

    public final TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        switch (verb) {
            case Attack: {
                return this.attack(turtle, direction);
            }
            case Dig: {
                return this.dig(turtle, direction);
            }
        }
        return TurtleCommandResult.failure((String)"Unsupported action");
    }

    public final void update(ITurtleAccess turtle, TurtleSide side) {
    }

    protected abstract boolean canAttackEntity(Entity var1);

    protected abstract ArrayList<ItemStack> attackEntity(ITurtleAccess var1, Entity var2) throws TurtleFailureAttack;

    protected abstract boolean canAttackBlock(World var1, int var2, int var3, int var4, int var5, EntityPlayer var6);

    protected abstract ArrayList<ItemStack> attackBlock(World var1, int var2, int var3, int var4, int var5, EntityPlayer var6) throws TurtleFailureAttack;

    protected abstract boolean canHarvestBlock(World var1, int var2, int var3, int var4);

    protected abstract ArrayList<ItemStack> harvestBlock(World var1, int var2, int var3, int var4) throws TurtleFailureDig;

    protected String getAttackFailureMessage() {
        return "Nothing to attack";
    }

    protected String getDigFailureMessage() {
        return "Nothing to dig";
    }

    protected final void store(ITurtleAccess turtle, ArrayList<ItemStack> list) {
        if (list != null) {
            for (ItemStack stack : list) {
                this.store(turtle, stack);
            }
        }
    }

    protected final void store(ITurtleAccess turtle, ItemStack stack) {
        if (!this.storeItemStack(turtle, stack)) {
            ChunkCoordinates coordinates = turtle.getPosition();
            int direction = turtle.getDirection();
            int x = coordinates.field_71574_a + Facing.field_71586_b[direction];
            int y = coordinates.field_71572_b + Facing.field_71587_c[direction];
            int z = coordinates.field_71573_c + Facing.field_71585_d[direction];
            InventoryUtils.spawnItemStackInWorld(stack, turtle.getWorld(), x, y, z);
        }
    }

    protected AxisAlignedBB getEntitySearchAABB(ITurtleAccess turtle, int dir) {
        ChunkCoordinates coordinates = turtle.getPosition();
        int x = coordinates.field_71574_a + Facing.field_71586_b[dir];
        int y = coordinates.field_71572_b + Facing.field_71587_c[dir];
        int z = coordinates.field_71573_c + Facing.field_71585_d[dir];
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0));
    }

    private TurtleCommandResult attack(ITurtleAccess turtle, int dir) {
        World world = turtle.getWorld();
        ChunkCoordinates coordinates = turtle.getPosition();
        int x = coordinates.field_71574_a + Facing.field_71586_b[dir];
        int y = coordinates.field_71572_b + Facing.field_71587_c[dir];
        int z = coordinates.field_71573_c + Facing.field_71585_d[dir];
        PlayerTurtle player = new PlayerTurtle(turtle);
        List list = world.func_72839_b((Entity)player, this.getEntitySearchAABB(turtle, dir));
        try {
            boolean someThingDone = false;
            for (Entity entity : list) {
                if (!this.canAttackEntity(entity)) continue;
                this.store(turtle, this.attackEntity(turtle, entity));
                someThingDone = true;
            }
            if (this.canAttackBlock(world, x, y, z, dir, (EntityPlayer)player)) {
                this.store(turtle, this.attackBlock(world, x, y, z, dir, (EntityPlayer)player));
                someThingDone = true;
            }
            if (someThingDone) {
                return TurtleCommandResult.success();
            }
            return TurtleCommandResult.failure((String)this.getAttackFailureMessage());
        }
        catch (TurtleFailureAttack e) {
            return TurtleCommandResult.failure((String)e.getMessage());
        }
    }

    private TurtleCommandResult dig(ITurtleAccess turtle, int dir) {
        World world = turtle.getWorld();
        ChunkCoordinates coordinates = turtle.getPosition();
        int x = coordinates.field_71574_a + Facing.field_71586_b[dir];
        int y = coordinates.field_71572_b + Facing.field_71587_c[dir];
        int z = coordinates.field_71573_c + Facing.field_71585_d[dir];
        Block block = world.func_147439_a(x, y, z);
        if (!world.func_147437_c(x, y, z) && block.func_149712_f(world, x, y, z) > -1.0f && this.canHarvestBlock(world, x, y, z)) {
            try {
                ArrayList<ItemStack> result = this.harvestBlock(world, x, y, z);
                if (result != null) {
                    this.store(turtle, result);
                    world.func_147468_f(x, y, z);
                    world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + world.func_72805_g(x, y, z) * 4096);
                    return TurtleCommandResult.success();
                }
            }
            catch (TurtleFailureDig e) {
                return TurtleCommandResult.failure((String)e.getMessage());
            }
        }
        return TurtleCommandResult.failure((String)this.getDigFailureMessage());
    }

    private boolean storeItemStack(ITurtleAccess turtle, ItemStack stack) {
        IInventory inventory = turtle.getInventory();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack currentStack = inventory.func_70301_a(i);
            if (currentStack == null) {
                inventory.func_70299_a(i, stack.func_77946_l());
                stack.field_77994_a = 0;
                return true;
            }
            if (!currentStack.func_77985_e() || !currentStack.func_77969_a(stack)) continue;
            int space = currentStack.func_77976_d() - currentStack.field_77994_a;
            if (space >= stack.field_77994_a) {
                currentStack.field_77994_a += stack.field_77994_a;
                stack.field_77994_a = 0;
                return true;
            }
            currentStack.field_77994_a = currentStack.func_77976_d();
            stack.field_77994_a -= space;
        }
        return false;
    }
}

