/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.api.peripheral.wrapper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.Computers;
import com.theoriginalbit.moarperipherals.api.peripheral.interfaces.IPFMount;
import com.theoriginalbit.moarperipherals.api.peripheral.wrapper.WrapperGeneric;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;

public class WrapperComputer
extends WrapperGeneric {
    private static final HashMap<Integer, Integer> MOUNT_COUNTS = Maps.newHashMap();
    private final ArrayList<IPFMount> mounts = Lists.newArrayList();

    public WrapperComputer(Object peripheral) {
        super(peripheral);
        Class<?> peripheralClass = peripheral.getClass();
        if (peripheralClass.isAnnotationPresent(Computers.Mount.class)) {
            Computers.Mount annotationMount = peripheralClass.getAnnotation(Computers.Mount.class);
            for (Class<? extends IPFMount> clazz : annotationMount.value()) {
                try {
                    IPFMount mount = clazz.newInstance();
                    this.mounts.add(mount);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void attach(IComputerAccess computer) {
        int id;
        super.attach(computer);
        if (this.mounts.isEmpty()) {
            return;
        }
        if (this.methodAttach != null) {
            try {
                this.methodAttach.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (!MOUNT_COUNTS.containsKey(id = computer.getID())) {
            MOUNT_COUNTS.put(id, 0);
        }
        int count = MOUNT_COUNTS.get(id);
        if (count++ == 0) {
            for (IPFMount mount : this.mounts) {
                computer.mount(mount.getMountLocation(), (IMount)mount);
            }
        }
        MOUNT_COUNTS.put(id, count);
    }

    @Override
    public void detach(IComputerAccess computer) {
        int id;
        super.detach(computer);
        if (this.mounts.isEmpty()) {
            return;
        }
        if (this.methodDetach != null) {
            try {
                this.methodDetach.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (!MOUNT_COUNTS.containsKey(id = computer.getID())) {
            return;
        }
        int count = MOUNT_COUNTS.get(id);
        if (--count == 0) {
            for (IPFMount mount : this.mounts) {
                computer.unmount(mount.getMountLocation());
            }
        }
        MOUNT_COUNTS.put(id, count);
    }
}

