/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.api.peripheral.wrapper;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.Computers;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.LuaPeripheral;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.Requires;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.Alias;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.LuaFunction;
import com.theoriginalbit.moarperipherals.api.peripheral.wrapper.WrapperMethod;
import cpw.mods.fml.common.Loader;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;

class WrapperGeneric
implements IPeripheral {
    protected final Object instance;
    protected final String peripheralType;
    protected final LinkedHashMap<String, WrapperMethod> methods = Maps.newLinkedHashMap();
    protected final String[] methodNames;
    protected final Method methodAttach;
    protected final Method methodDetach;
    protected final ArrayList<IComputerAccess> computers = Lists.newArrayList();

    public WrapperGeneric(Object peripheral) {
        Class<?> peripheralClass = peripheral.getClass();
        LuaPeripheral peripheralLua = peripheralClass.getAnnotation(LuaPeripheral.class);
        String pname = peripheralLua.value().trim();
        Preconditions.checkArgument((!pname.isEmpty() ? 1 : 0) != 0, (Object)"Peripheral name cannot be an empty string");
        Method attach = null;
        Method detach = null;
        for (Method method : peripheralClass.getMethods()) {
            if (this.isEnabledLuaFunction(method)) {
                this.wrapMethod(peripheral, method);
            } else if (method.isAnnotationPresent(Alias.class)) {
                throw new RuntimeException("Alias annotations should only occur on LuaFunction annotated methods");
            }
            if (method.isAnnotationPresent(Computers.Attach.class)) {
                attach = method;
            }
            if (!method.isAnnotationPresent(Computers.Detach.class)) continue;
            detach = method;
        }
        for (AccessibleObject accessibleObject : peripheralClass.getDeclaredFields()) {
            if (!accessibleObject.isAnnotationPresent(Computers.List.class)) continue;
            try {
                ((Field)accessibleObject).set(peripheral, this.computers);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.instance = peripheral;
        this.peripheralType = pname;
        this.methodAttach = this.checkEventMethod(attach, "@Computers.Attach");
        this.methodDetach = this.checkEventMethod(detach, "@Computers.Detach");
        Set<String> keys = this.methods.keySet();
        this.methodNames = keys.toArray(new String[keys.size()]);
    }

    public final Object getInstance() {
        return this.instance;
    }

    public String getType() {
        return this.peripheralType;
    }

    public String[] getMethodNames() {
        return this.methodNames;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int methodIdx, Object[] arguments) throws LuaException, InterruptedException {
        if (this.instance instanceof TileEntity && ((TileEntity)this.instance).func_145837_r()) {
            throw new LuaException("peripheral no longer exists");
        }
        String name = this.methodNames[methodIdx];
        WrapperMethod method = this.methods.get(name);
        return method.invoke(computer, context, arguments);
    }

    public void attach(IComputerAccess computer) {
        if (!this.computers.contains(computer)) {
            this.computers.add(computer);
        }
        if (this.methodAttach != null) {
            try {
                this.methodAttach.invoke(this.instance, computer);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void detach(IComputerAccess computer) {
        if (this.computers.contains(computer)) {
            this.computers.remove(computer);
        }
        if (this.methodDetach != null) {
            try {
                this.methodDetach.invoke(this.instance, computer);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean equals(IPeripheral other) {
        return super.equals(other);
    }

    private void wrapMethod(Object peripheral, Method method) {
        LuaFunction annotation = method.getAnnotation(LuaFunction.class);
        String name = annotation.value().trim().isEmpty() ? method.getName() : annotation.value().trim();
        Preconditions.checkArgument((!this.methods.containsKey(name) ? 1 : 0) != 0, (Object)("Duplicate method found " + name + ". Either make use of the name in the LuaFunction annotation, or if these methods do the same purpose use the Alias annotation instead."));
        WrapperMethod wrapper = new WrapperMethod(peripheral, method);
        this.methods.put(name, wrapper);
        if (method.isAnnotationPresent(Alias.class)) {
            for (String alias : method.getAnnotation(Alias.class).value()) {
                Preconditions.checkArgument((!this.methods.containsKey(alias) ? 1 : 0) != 0, (Object)("Duplicate method found while attempting to apply Alias " + alias));
                this.methods.put(alias, wrapper);
            }
        }
    }

    private boolean isEnabledLuaFunction(Method method) {
        if (!method.isAnnotationPresent(LuaFunction.class)) {
            return false;
        }
        if (!method.isAnnotationPresent(Requires.class)) {
            return true;
        }
        Requires requires = method.getAnnotation(Requires.class);
        String[] modIds = requires.modIds();
        boolean allRequired = requires.allRequired();
        for (String mid : modIds) {
            boolean loaded = Loader.isModLoaded((String)mid);
            if (loaded && !allRequired) {
                return true;
            }
            if (loaded || !allRequired) continue;
            return false;
        }
        return true;
    }

    private Method checkEventMethod(Method m, String type) {
        if (m == null) {
            return null;
        }
        Class<?>[] params = m.getParameterTypes();
        if (params.length == 0) {
            return m;
        }
        boolean valid = params.length == 1 && IComputerAccess.class.isAssignableFrom(params[0]);
        Preconditions.checkArgument((boolean)valid, (Object)(type + " method can only have one parameters of type IComputerAccess"));
        return m;
    }
}

