/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.api.peripheral.wrapper;

import com.google.common.base.Preconditions;
import com.theoriginalbit.moarperipherals.api.peripheral.LuaType;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.LuaFunction;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.MultiReturn;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WrapperMethod {
    private final Method method;
    private final Object instance;
    private final int luaParamsCount;
    private final Class<?>[] javaParams;
    private final boolean isMultiReturn;

    public WrapperMethod(Object peripheral, Method m) {
        Preconditions.checkArgument((boolean)m.isAnnotationPresent(LuaFunction.class));
        this.instance = peripheral;
        this.method = m;
        this.javaParams = this.method.getParameterTypes();
        this.isMultiReturn = m.isAnnotationPresent(MultiReturn.class);
        int count = this.javaParams.length;
        for (Class<?> clazz : this.javaParams) {
            if (IComputerAccess.class.isAssignableFrom(clazz)) {
                --count;
                continue;
            }
            if (!ILuaContext.class.isAssignableFrom(clazz)) continue;
            --count;
        }
        this.luaParamsCount = count;
    }

    public Object[] invoke(IComputerAccess access, ILuaContext context, Object[] arguments) throws LuaException, InterruptedException {
        if (arguments.length != this.luaParamsCount) {
            throw new LuaException(String.format("expected %d arg(s), got %d", this.luaParamsCount, arguments.length));
        }
        Object[] args = new Object[this.javaParams.length];
        for (int i = 0; i < args.length; ++i) {
            if (IComputerAccess.class.isAssignableFrom(this.javaParams[i])) {
                args[i] = access;
                continue;
            }
            if (ILuaContext.class.isAssignableFrom(this.javaParams[i])) {
                args[i] = context;
                continue;
            }
            if (arguments[i] != null) {
                Object convert = LuaType.fromLua(arguments[i], this.javaParams[i]);
                if (convert == null) {
                    throw new LuaException(String.format("expected %s, got %s", LuaType.getLuaName(this.javaParams[i]), LuaType.getLuaName(arguments[i].getClass())));
                }
                args[i] = convert;
                continue;
            }
            throw new LuaException(String.format("expected %s, got nil", LuaType.getLuaName(this.javaParams[i])));
        }
        try {
            if (this.isMultiReturn) {
                Object[] result = (Object[])this.method.invoke(this.instance, args);
                for (int i = 0; i < result.length; ++i) {
                    result[i] = LuaType.toLua(result[i]);
                }
                return result;
            }
            return new Object[]{LuaType.toLua(this.method.invoke(this.instance, args))};
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            throw new LuaException("Developer problem, please present your client log file to the developer of this peripheral.");
        }
        catch (InvocationTargetException e) {
            String message;
            Throwable cause = e;
            while ((message = cause.getMessage()) == null && (cause = ((Throwable)cause).getCause()) != null) {
            }
            throw new LuaException(message);
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
    }
}

