/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.client;

import com.theoriginalbit.moarperipherals.api.upgrade.IUpgradeIcon;
import com.theoriginalbit.moarperipherals.api.upgrade.IUpgradeToolIcon;
import com.theoriginalbit.moarperipherals.client.render.RendererAntenna;
import com.theoriginalbit.moarperipherals.client.render.RendererAntennaController;
import com.theoriginalbit.moarperipherals.client.render.RendererInkCartridge;
import com.theoriginalbit.moarperipherals.client.render.RendererItemSonic;
import com.theoriginalbit.moarperipherals.client.render.RendererKeyboard;
import com.theoriginalbit.moarperipherals.client.render.RendererMiniAntenna;
import com.theoriginalbit.moarperipherals.client.render.RendererPrinter;
import com.theoriginalbit.moarperipherals.client.render.RendererTileAntenna;
import com.theoriginalbit.moarperipherals.common.ProxyCommon;
import com.theoriginalbit.moarperipherals.common.config.ConfigHandler;
import com.theoriginalbit.moarperipherals.common.reference.Constants;
import com.theoriginalbit.moarperipherals.common.registry.ModBlocks;
import com.theoriginalbit.moarperipherals.common.registry.ModItems;
import com.theoriginalbit.moarperipherals.common.registry.UpgradeRegistry;
import com.theoriginalbit.moarperipherals.common.tile.TileAntennaController;
import com.theoriginalbit.moarperipherals.common.tile.TileKeyboard;
import com.theoriginalbit.moarperipherals.common.tile.TileMiniAntenna;
import com.theoriginalbit.moarperipherals.common.tile.TilePrinter;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

public class ProxyClient
extends ProxyCommon {
    private final Minecraft mc = Minecraft.func_71410_x();

    @Override
    public void postInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public World getClientWorld(int dimId) {
        if (this.mc.field_71441_e.field_73011_w.field_76574_g == dimId) {
            return this.mc.field_71441_e;
        }
        return null;
    }

    @Override
    public void playSound(double x, double y, double z, String name, float volume, float pitch, boolean delayed) {
        double distanceSq = this.mc.field_71451_h.func_70092_e(x, y, z);
        PositionedSoundRecord sound = new PositionedSoundRecord(new ResourceLocation(name), volume, pitch, (float)x, (float)y, (float)z);
        if (delayed && distanceSq > 100.0) {
            double distance = Math.sqrt(distanceSq) / 40.0;
            this.mc.func_147118_V().func_147681_a((ISound)sound, (int)(distance * 20.0));
        } else {
            this.mc.func_147118_V().func_147682_a((ISound)sound);
        }
    }

    @Override
    public boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    @Override
    public void registerRenderInfo() {
        if (ConfigHandler.enableKeyboard) {
            RendererKeyboard rendererKeyboard = new RendererKeyboard();
            MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.blockKeyboardMac), (IItemRenderer)rendererKeyboard);
            MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.blockKeyboardPc), (IItemRenderer)rendererKeyboard);
            ClientRegistry.bindTileEntitySpecialRenderer(TileKeyboard.class, (TileEntitySpecialRenderer)rendererKeyboard);
        }
        if (ConfigHandler.enablePrinter && ConfigHandler.enablePrinterGfx) {
            RendererPrinter rendererPrinter = new RendererPrinter();
            MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.blockPrinter), (IItemRenderer)rendererPrinter);
            ClientRegistry.bindTileEntitySpecialRenderer(TilePrinter.class, (TileEntitySpecialRenderer)rendererPrinter);
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.itemInkCartridge, (IItemRenderer)new RendererInkCartridge());
        }
        if (ConfigHandler.isSonicEnabled() && ConfigHandler.enableSonicGfx) {
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.itemSonic, (IItemRenderer)new RendererItemSonic());
        }
        if (ConfigHandler.enableAntenna) {
            Constants.RENDER_ID.ANTENNA = RenderingRegistry.getNextAvailableRenderId();
            Constants.RENDER_ID.ANTENNA_CTRLR = RenderingRegistry.getNextAvailableRenderId();
            RenderingRegistry.registerBlockHandler((int)Constants.RENDER_ID.ANTENNA, (ISimpleBlockRenderingHandler)new RendererAntenna());
            RenderingRegistry.registerBlockHandler((int)Constants.RENDER_ID.ANTENNA_CTRLR, (ISimpleBlockRenderingHandler)new RendererAntennaController());
            ClientRegistry.bindTileEntitySpecialRenderer(TileAntennaController.class, (TileEntitySpecialRenderer)new RendererTileAntenna());
        }
        if (ConfigHandler.enableMiniAntenna) {
            RendererMiniAntenna rendererMiniAntenna = new RendererMiniAntenna();
            ClientRegistry.bindTileEntitySpecialRenderer(TileMiniAntenna.class, (TileEntitySpecialRenderer)rendererMiniAntenna);
        }
    }

    @Override
    public boolean isOp(EntityPlayer player) {
        return false;
    }

    @Override
    public File getBase() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @SubscribeEvent
    public void onPreTextureStitch(TextureStitchEvent.Pre event) {
        this.addTextures(event.map);
    }

    private void addTextures(TextureMap map) {
        boolean terrain;
        boolean bl = terrain = map.func_130086_a() == 1;
        if (terrain) {
            for (ITurtleUpgrade upgrade : UpgradeRegistry.UPGRADES) {
                if (!(upgrade instanceof IUpgradeIcon)) continue;
                ((IUpgradeIcon)upgrade).registerIcons((IIconRegister)map);
            }
        } else {
            for (ITurtleUpgrade upgrade : UpgradeRegistry.UPGRADES) {
                if (!(upgrade instanceof IUpgradeToolIcon)) continue;
                ((IUpgradeToolIcon)upgrade).registerIcons((IIconRegister)map);
            }
        }
    }
}

