/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.client.render;

import com.theoriginalbit.moarperipherals.client.model.ModelInkCartridge;
import com.theoriginalbit.moarperipherals.common.reference.Constants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RendererInkCartridge
implements IItemRenderer {
    private static final ModelBase modelCartridgeEmpty = new ModelInkCartridge(true);
    private static final ModelBase modelCartridgeFilled = new ModelInkCartridge(false);

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper != IItemRenderer.ItemRendererHelper.BLOCK_3D;
    }

    public final void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        GL11.glPushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTexture(stack));
        ModelBase model = this.selectModel(stack);
        switch (type) {
            case ENTITY: {
                this.manipulateEntityRender();
                model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                break;
            }
            case EQUIPPED: {
                this.manipulateThirdPersonRender();
                model.func_78088_a((Entity)data[1], 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.manipulateFirstPersonRender();
                model.func_78088_a((Entity)data[1], 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                break;
            }
            case INVENTORY: {
                this.manipulateInventoryRender();
                model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                break;
            }
        }
        GL11.glPopMatrix();
    }

    private void manipulateEntityRender() {
        float scale = 0.24f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
    }

    private void manipulateThirdPersonRender() {
        float scale = 0.3f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-55.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)-40.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-3.2f, (float)2.1f, (float)-1.7f);
    }

    private void manipulateFirstPersonRender() {
        float scale = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)170.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)40.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-60.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)-2.2f, (float)-1.0f, (float)-1.5f);
    }

    private void manipulateInventoryRender() {
        float scale = 0.6f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
    }

    private ResourceLocation getTexture(ItemStack stack) {
        Constants.TextureStore texture;
        switch (stack.func_77960_j()) {
            case 0: {
                texture = Constants.TEXTURES_MODEL.INK_CARTRIDGE_C;
                break;
            }
            case 1: {
                texture = Constants.TEXTURES_MODEL.INK_CARTRIDGE_M;
                break;
            }
            case 2: {
                texture = Constants.TEXTURES_MODEL.INK_CARTRIDGE_Y;
                break;
            }
            case 3: {
                texture = Constants.TEXTURES_MODEL.INK_CARTRIDGE_K;
                break;
            }
            default: {
                texture = Constants.TEXTURES_MODEL.INK_CARTRIDGE_E;
            }
        }
        return texture.getResourceLocation();
    }

    private ModelBase selectModel(ItemStack stack) {
        return stack.func_77960_j() == 4 ? modelCartridgeEmpty : modelCartridgeFilled;
    }
}

