/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.client.render;

import com.theoriginalbit.moarperipherals.client.model.ModelPrinter;
import com.theoriginalbit.moarperipherals.common.tile.TilePrinter;
import com.theoriginalbit.moarperipherals.common.tile.printer.PaperState;
import com.theoriginalbit.moarperipherals.common.tile.printer.PrinterState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RendererPrinter
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private static final ModelBase PRINTER_EMPTY = new ModelPrinter(false, false);
    private static final ModelBase PRINTER_INPUT = new ModelPrinter(true, false);
    private static final ModelBase PRINTER_OUTPUT = new ModelPrinter(false, true);
    private static final ModelBase PRINTER_BOTH = new ModelPrinter(true, true);

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTick) {
        TilePrinter printer = (TilePrinter)tile;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float scale = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-1.0f, (float)-0.44f, (float)1.0f);
        this.adjustRotatePivotViaMeta(tile);
        GL11.glPushMatrix();
        this.func_147499_a(this.getTexture(printer.getPrinterState()));
        this.getModel(printer.getPaperState()).func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper != IItemRenderer.ItemRendererHelper.BLOCK_3D;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        GL11.glPushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PrinterState.IDLE.getTexture());
        ModelBase model = this.getModel(PaperState.PAPER_BOTH);
        switch (type) {
            case ENTITY: {
                this.manipulateEntityRender();
                model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                break;
            }
            case EQUIPPED: {
                this.manipulateThirdPersonRender();
                model.func_78088_a((Entity)data[1], 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.manipulateFirstPersonRender();
                model.func_78088_a((Entity)data[1], 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                break;
            }
            case INVENTORY: {
                this.manipulateInventoryRender();
                model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                break;
            }
        }
        GL11.glPopMatrix();
    }

    private void manipulateEntityRender() {
        float scale = 0.9f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
    }

    private void manipulateThirdPersonRender() {
        float scale = 0.8f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-40.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)-100.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-1.8f, (float)0.5f, (float)0.5f);
    }

    private void manipulateFirstPersonRender() {
        float scale = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)170.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)40.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-60.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)-2.2f, (float)-1.0f, (float)-1.5f);
    }

    private void manipulateInventoryRender() {
        float scale = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.3f, (float)0.0f);
    }

    private ResourceLocation getTexture(PrinterState state) {
        return state.getTexture();
    }

    private ModelBase getModel(PaperState state) {
        switch (state) {
            case PAPER_NONE: {
                return PRINTER_EMPTY;
            }
            case PAPER_INPUT: {
                return PRINTER_INPUT;
            }
            case PAPER_OUTPUT: {
                return PRINTER_OUTPUT;
            }
        }
        return PRINTER_BOTH;
    }

    private void adjustRotatePivotViaMeta(TileEntity tile) {
        switch (tile.func_145832_p()) {
            case 2: {
                break;
            }
            case 3: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
    }
}

