/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.client.render.abstracts;

import com.theoriginalbit.moarperipherals.common.reference.Constants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public abstract class CustomItemRenderer
implements IItemRenderer {
    private ModelBase modelItem;

    public CustomItemRenderer(ModelBase model) {
        this.modelItem = model;
    }

    public boolean handleRenderType(ItemStack stack, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case INVENTORY_BLOCK: {
                return true;
            }
            case ENTITY_BOBBING: {
                return true;
            }
            case ENTITY_ROTATION: {
                return true;
            }
            case EQUIPPED_BLOCK: {
                return true;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        GL11.glPushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTexture(type, stack).getResourceLocation());
        ModelBase model = this.selectModel(stack);
        switch (type) {
            case ENTITY: {
                this.manipulateEntityRender(stack);
                model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                break;
            }
            case EQUIPPED: {
                this.manipulateThirdPersonRender(stack);
                model.func_78088_a((Entity)data[1], 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.manipulateFirstPersonRender(stack);
                model.func_78088_a((Entity)data[1], 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                break;
            }
            case INVENTORY: {
                this.manipulateInventoryRender(stack);
                model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                break;
            }
        }
        GL11.glPopMatrix();
    }

    protected ModelBase selectModel(ItemStack stack) {
        return this.modelItem;
    }

    protected abstract Constants.TextureStore getTexture(IItemRenderer.ItemRenderType var1, ItemStack var2);

    protected abstract void manipulateEntityRender(ItemStack var1);

    protected abstract void manipulateInventoryRender(ItemStack var1);

    protected abstract void manipulateThirdPersonRender(ItemStack var1);

    protected abstract void manipulateFirstPersonRender(ItemStack var1);
}

