/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.block;

import com.theoriginalbit.moarperipherals.MoarPeripherals;
import com.theoriginalbit.moarperipherals.api.tile.aware.IActivateAwareTile;
import com.theoriginalbit.moarperipherals.client.gui.GuiType;
import com.theoriginalbit.moarperipherals.common.block.abstracts.BlockPaired;
import com.theoriginalbit.moarperipherals.common.block.abstracts.BlockRotatable;
import com.theoriginalbit.moarperipherals.common.item.ItemSonic;
import com.theoriginalbit.moarperipherals.common.reference.Constants;
import com.theoriginalbit.moarperipherals.common.tile.TileKeyboard;
import com.theoriginalbit.moarperipherals.common.utils.ReflectionUtils;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockKeyboardMac
extends BlockPaired {
    private static final Class<?> CLASS_ITOOLWRENCH = ReflectionUtils.getClass("buildcraft.api.tools.IToolWrench");
    private final ForgeDirection[] validDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};

    public BlockKeyboardMac() {
        this("keyboardMac");
    }

    protected BlockKeyboardMac(String name) {
        super(Material.field_151573_f, name);
        this.setRotationMode(BlockRotatable.RotationMode.FOUR);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    public TileEntity func_149915_a(World world, int par1) {
        return new TileKeyboard();
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public final boolean func_149707_d(World world, int x, int y, int z, int side) {
        return this.isOnTopOfSolidBlock(world, x, y, z, ForgeDirection.getOrientation((int)side).getOpposite());
    }

    @Override
    public boolean func_149727_a(final World world, final int x, final int y, final int z, final EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack equipped = player.func_71045_bC();
        if (equipped != null && BlockKeyboardMac.isItemWrench(equipped.func_77973_b())) {
            return true;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileKeyboard) {
            TileKeyboard keyboard = (TileKeyboard)tile;
            if (keyboard.hasConnection()) {
                if (keyboard.isTargetInRange()) {
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            player.openGui((Object)MoarPeripherals.instance, GuiType.KEYBOARD.ordinal(), world, x, y, z);
                        }
                    }, 1000L);
                }
            } else if (!world.field_72995_K) {
                String message = EnumChatFormatting.RED + Constants.CHAT.CHAT_NOT_PAIRED.getLocalised();
                player.func_146105_b((IChatComponent)new ChatComponentText(message));
            }
            return ((IActivateAwareTile)tile).onActivated(player, side, hitX, hitY, hitZ);
        }
        return super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.8f, 0.1f, 0.8f);
        super.func_149743_a(world, x, y, z, mask, list, entity);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        return this.validDirections;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection direction) {
        switch (direction) {
            case UP: {
                return false;
            }
            case DOWN: {
                return false;
            }
        }
        return world.func_72805_g(x, y, z) == direction.ordinal() || world.func_72921_c(x, y, z, direction.ordinal(), 2);
    }

    private boolean isOnTopOfSolidBlock(World world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.DOWN && BlockKeyboardMac.isNeighborBlockSolid(world, x, y, z, ForgeDirection.DOWN);
    }

    private static boolean isNeighborBlockSolid(World world, int x, int y, int z, ForgeDirection side) {
        return world.isSideSolid(x += side.offsetX, y += side.offsetY, z += side.offsetZ, side.getOpposite());
    }

    private static boolean isItemWrench(Item item) {
        return CLASS_ITOOLWRENCH != null && item.getClass().isAssignableFrom(CLASS_ITOOLWRENCH) || item instanceof ItemSonic;
    }
}

