/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.block.abstracts;

import com.google.common.collect.Lists;
import com.theoriginalbit.moarperipherals.MoarPeripherals;
import com.theoriginalbit.moarperipherals.api.tile.IHasGui;
import com.theoriginalbit.moarperipherals.api.tile.IHasSpecialDrops;
import com.theoriginalbit.moarperipherals.api.tile.IPairedDevice;
import com.theoriginalbit.moarperipherals.api.tile.aware.IActivateAwareTile;
import com.theoriginalbit.moarperipherals.api.tile.aware.IBreakAwareTile;
import com.theoriginalbit.moarperipherals.api.tile.aware.INeighborAwareTile;
import com.theoriginalbit.moarperipherals.api.tile.aware.IPlaceAwareTile;
import com.theoriginalbit.moarperipherals.common.reference.ModInfo;
import com.theoriginalbit.moarperipherals.common.tile.abstracts.TileMoarP;
import com.theoriginalbit.moarperipherals.common.utils.InventoryUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockMoarP
extends BlockContainer {
    protected final String blockName;
    protected final IIcon[] icons = new IIcon[6];

    public BlockMoarP(String name) {
        this(Material.field_151576_e, name);
    }

    public BlockMoarP(Material material, String name) {
        super(material);
        this.blockName = name;
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149647_a(MoarPeripherals.creativeTab);
        this.func_149663_c(ModInfo.RESOURCE_DOMAIN + ':' + this.blockName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister registry) {
        IIcon icon = registry.func_94245_a(ModInfo.RESOURCE_DOMAIN + ":" + this.blockName);
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = icon;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[side];
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IPlaceAwareTile) {
            ((IPlaceAwareTile)tile).onPlaced(entity, stack, x, y, z);
        }
        if (tile != null && entity instanceof EntityPlayer) {
            ((TileMoarP)tile).setOwner(((EntityPlayer)entity).getDisplayName());
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IHasGui) {
            player.openGui((Object)MoarPeripherals.instance, ((IHasGui)tile).getGuiId().ordinal(), world, x, y, z);
            return true;
        }
        return tile instanceof IActivateAwareTile && ((IActivateAwareTile)tile).onActivated(player, side, hitX, hitY, hitZ);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IBreakAwareTile) {
            ((IBreakAwareTile)tile).onBreak(x, y, z);
        }
        if (tile instanceof IInventory) {
            InventoryUtils.explodeInventory((IInventory)tile, world, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harvest) {
        TileEntity tile = world.func_147438_o(x, y, z);
        ArrayList tileDrops = Lists.newArrayList();
        if (tile instanceof IPairedDevice) {
            ItemStack drop = ((IPairedDevice)tile).getPairedDrop();
            tileDrops.add(drop);
        }
        if (tile instanceof IHasSpecialDrops) {
            ((IHasSpecialDrops)tile).addDrops(tileDrops);
        }
        for (ItemStack stack : tileDrops) {
            this.func_149642_a(world, x, y, z, stack);
        }
        return super.removedByPlayer(world, player, x, y, z, harvest);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof INeighborAwareTile) {
            ((INeighborAwareTile)tile).onNeighbourChanged();
        }
        super.func_149695_a(world, x, y, z, block);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }
}

