/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.chunk;

import com.google.common.collect.Maps;
import com.theoriginalbit.moarperipherals.common.chunk.IChunkLoader;
import com.theoriginalbit.moarperipherals.common.chunk.TicketManager;
import com.theoriginalbit.moarperipherals.common.utils.LogUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoadingCallback
implements ForgeChunkManager.LoadingCallback {
    public static final HashMap<IChunkLoader, ForgeChunkManager.Ticket> ticketList = Maps.newHashMap();

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        LogUtils.debug("Previous chunk loading tickets exist, loading...", new Object[0]);
        for (ForgeChunkManager.Ticket ticket : tickets) {
            try {
                if (ChunkLoadingCallback.ticketLoad(ticket, world)) continue;
                LogUtils.warn("Served an invalid chunk loading ticket. Releasing.", new Object[0]);
                TicketManager.releaseTicket(ticket);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean ticketLoad(ForgeChunkManager.Ticket ticket, World world) {
        int z;
        int y;
        NBTTagCompound tag = ticket.getModData();
        int x = tag.func_74762_e("targetX");
        TileEntity tile = world.func_147438_o(x, y = tag.func_74762_e("targetY"), z = tag.func_74762_e("targetZ"));
        if (tile == null) {
            LogUtils.debug(String.format("No TileEntity at %d %d %d", x, y, z), new Object[0]);
            return false;
        }
        if (!(tile instanceof IChunkLoader)) {
            LogUtils.warn(String.format("Served ticket for TileEntity at %d %d %d that is not one of mine", x, y, z), new Object[0]);
            return false;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)((IChunkLoader)tile).getChunkCoord());
        ticketList.put((IChunkLoader)tile, ticket);
        return true;
    }
}

