/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.chunk;

import com.google.common.collect.Sets;
import com.theoriginalbit.moarperipherals.MoarPeripherals;
import com.theoriginalbit.moarperipherals.common.utils.LogUtils;
import java.util.HashSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public final class TicketManager {
    public static HashSet<ForgeChunkManager.Ticket> tickets = Sets.newHashSet();

    public static ForgeChunkManager.Ticket requestTicket(World world, int x, int y, int z) {
        ForgeChunkManager.Ticket ticket = null;
        if (!world.field_72995_K) {
            LogUtils.debug(String.format("Requesting chunk loading ticket for TileEntity at %d %d %d", x, y, z), new Object[0]);
            ticket = ForgeChunkManager.requestTicket((Object)MoarPeripherals.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (ticket != null) {
                tickets.add(ticket);
                NBTTagCompound tag = ticket.getModData();
                tag.func_74768_a("targetX", x);
                tag.func_74768_a("targetY", y);
                tag.func_74768_a("targetZ", z);
            }
        }
        return ticket;
    }

    public static void releaseTicket(ForgeChunkManager.Ticket ticket) {
        if (tickets.contains(ticket)) {
            LogUtils.debug("Releasing chunk loading ticket.", new Object[0]);
            tickets.remove(ticket);
        }
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
    }
}

