/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.config;

import com.theoriginalbit.moarperipherals.common.utils.LogUtils;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public final class ConfigHandler {
    private static final String ENABLEFORMAT = "Enable the %s";
    public static final String CATEGORY_ENABLED = "Enabled";
    public static final String CATEGORY_UPGRADE = "Upgrades";
    public static final String CATEGORY_CHAT_BOX = "ChatBox";
    public static final String CATEGORY_PRINTER = "Printer";
    public static final String CATEGORY_RENDERER = "Render";
    public static final String CATEGORY_KEYBOARD = "Keyboard";
    public static final String CATEGORY_SECURITY = "Security";
    public static final String CATEGORY_IRON_NOTE = "Iron Note";
    public static final String CATEGORY_SONIC = "Sonic Screwdriver";
    public static final String CATEGORY_FIREWORK = "Firework Launcher";
    public static final String CATEGORY_ANTENNA = "Communications Tower";
    public static final String CATEGORY_PLAYER_DETECTOR = "Player Detector";
    public static final String CATEGORY_TURTLE_TELEPORT = "Turtle Teleport";
    public static final String CATEGORY_MINI_ANTENNA = "Communications Antenna";
    public static final String CATEGORY_UPGRADE_FURNACE = "Furnace Turtle";
    public static final String CATEGORY_UPGRADE_DENSITY = "Density Scanning Turtle";
    private static int startUpgradeID = 16384;
    public static int upgradeIdChatBox = startUpgradeID++;
    public static int upgradeIdIronNote = startUpgradeID++;
    public static int upgradeIdCompass = startUpgradeID++;
    public static int upgradeIdShears = startUpgradeID++;
    public static int upgradeIdFurnace = startUpgradeID++;
    public static int upgradeIdSolar = startUpgradeID++;
    public static int upgradeIdIgniter = startUpgradeID++;
    public static int upgradeIdFeeder = startUpgradeID++;
    public static int upgradeIdOreScanner = startUpgradeID++;
    public static boolean enableSonic;
    public static boolean enableChatBox;
    public static boolean enablePrinter;
    public static boolean enableKeyboard;
    public static boolean enableIronNote;
    public static boolean enablePlayerDetector;
    public static boolean enableAntenna;
    public static boolean enableTurtleTeleport;
    public static boolean enableMiniAntenna;
    public static boolean enableFireworkLauncher;
    public static boolean enableComputerCrafter;
    public static boolean enableUpgradeShears;
    public static boolean enableUpgradeCompass;
    public static boolean enableUpgradeSolar;
    public static boolean enableUpgradeIgniter;
    public static boolean enableUpgradeFurnace;
    public static boolean enableUpgradeFeeder;
    public static boolean enableUpgradeOreScanner;
    public static boolean displayChatBoxCoords;
    public static int chatRangeSay;
    public static int chatRangeTell;
    public static int chatRangeRead;
    public static int chatSayRate;
    public static int noteRange;
    public static int keyboardRange;
    public static int antennaRange;
    public static int antennaRangeStorm;
    public static int antennaMessageDelay;
    public static boolean antennaKeepsChunkLoaded;
    public static double fuelMultiplier;
    public static int miniAntennaRange;
    public static int miniAntennaRangeStorm;
    public static int miniAntennaMessageDelay;
    public static int upgradeFurnaceFuelConsumption;
    public static String userDensityMappings;
    public static boolean enablePrinterGfx;
    public static boolean enableSonicGfx;
    public static boolean securityOpBreak;
    public static boolean debug;
    public static Configuration config;
    private static ConfigHandler INSTANCE;

    public static boolean isSonicEnabled() {
        return enableSonic;
    }

    public static boolean shouldChunkLoad() {
        return antennaKeepsChunkLoaded;
    }

    public static ConfigHandler instance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("ConfigHandler must be initialised");
        }
        return INSTANCE;
    }

    private ConfigHandler(File file) {
        config = new Configuration(file);
        this.doConfiguration();
    }

    public static ConfigHandler init(File file) {
        if (INSTANCE != null) {
            throw new IllegalStateException("ConfigHandler already initialised");
        }
        INSTANCE = new ConfigHandler(file);
        return INSTANCE;
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("MoarPeripherals")) {
            LogUtils.info("Refreshing the config file...", new Object[0]);
            this.doConfiguration();
        }
    }

    private void doConfiguration() {
        LogUtils.info("Loading MoarPeripherals configuration file", new Object[0]);
        enableSonic = ConfigHandler.getEnabled(CATEGORY_SONIC);
        enableChatBox = ConfigHandler.getEnabled(CATEGORY_CHAT_BOX);
        enablePrinter = false;
        enableKeyboard = ConfigHandler.getEnabled(CATEGORY_KEYBOARD);
        enableIronNote = ConfigHandler.getEnabled(CATEGORY_IRON_NOTE);
        enablePlayerDetector = ConfigHandler.getEnabled(CATEGORY_PLAYER_DETECTOR);
        enableAntenna = ConfigHandler.getEnabled(CATEGORY_ANTENNA);
        enableTurtleTeleport = ConfigHandler.getEnabled(CATEGORY_TURTLE_TELEPORT);
        enableMiniAntenna = ConfigHandler.getEnabled(CATEGORY_MINI_ANTENNA);
        enableFireworkLauncher = ConfigHandler.getEnabled(CATEGORY_FIREWORK);
        enableComputerCrafter = ConfigHandler.getEnabled("Computer Crafter");
        enableUpgradeShears = ConfigHandler.getUpgradeEnabled("Shears Turtle");
        enableUpgradeCompass = ConfigHandler.getUpgradeEnabled("Compass Turtle");
        enableUpgradeSolar = ConfigHandler.getUpgradeEnabled("Solar Turtle");
        enableUpgradeIgniter = ConfigHandler.getUpgradeEnabled("Igniter Turtle");
        enableUpgradeFurnace = ConfigHandler.getUpgradeEnabled(CATEGORY_UPGRADE_FURNACE);
        enableUpgradeFeeder = ConfigHandler.getUpgradeEnabled("Feeding Turtle");
        enableUpgradeOreScanner = ConfigHandler.getUpgradeEnabled(CATEGORY_UPGRADE_DENSITY);
        displayChatBoxCoords = ConfigHandler.getBoolean(CATEGORY_CHAT_BOX, "displayCoords", false, "Show the x, y, and z coordinates of the ChatBox in chat messages");
        chatRangeSay = ConfigHandler.getInt(CATEGORY_CHAT_BOX, "sayRange", chatRangeSay, "Range for the ChatBox peripheral's say function, set to -1 for infinite");
        chatRangeTell = ConfigHandler.getInt(CATEGORY_CHAT_BOX, "tellRange", chatRangeSay, "Range for the ChatBox peripheral's tell (private message) function, set to -1 for infinite");
        chatRangeRead = ConfigHandler.getInt(CATEGORY_CHAT_BOX, "readRange", chatRangeRead, "Range for the ChatBox peripheral's ability to 'hear' the chat, set to -1 for infinite");
        chatSayRate = ConfigHandler.getInt(CATEGORY_CHAT_BOX, "sayRate", chatSayRate, "Maximum number of messages per second a ChatBox peripheral can 'say'");
        noteRange = ConfigHandler.getInt(CATEGORY_IRON_NOTE, "noteRange", noteRange, "The range at which the note can be heard. Note: Does not seem to work for audio, yet (?).");
        keyboardRange = ConfigHandler.getInt(CATEGORY_KEYBOARD, "keyboardRange", keyboardRange, "The range that a keyboard can connect to a computer from. This cannot be infinite.");
        antennaRange = ConfigHandler.getInt(CATEGORY_ANTENNA, "towerRange", antennaRange, "The range in blocks the BitNet Communications Tower can transmit");
        antennaRangeStorm = ConfigHandler.getInt(CATEGORY_ANTENNA, "towerRangeStorm", antennaRangeStorm, "The range in blocks the BitNet Communications Tower can transmit during a storm");
        antennaMessageDelay = ConfigHandler.getInt(CATEGORY_ANTENNA, "towerMessageDelay", antennaMessageDelay, "The delay (in ticks) that the BitNet Communications Tower takes to send a message per 100 block distance (rounded up).");
        antennaKeepsChunkLoaded = ConfigHandler.getBoolean(CATEGORY_ANTENNA, "keepChunkLoaded", "Whether a BitNet Communications Tower should keep the chunk it resides in loaded");
        fuelMultiplier = ConfigHandler.getDouble(CATEGORY_TURTLE_TELEPORT, "fuelMultiplier", fuelMultiplier, "The multiplier for the fuel consumption to teleport the Turtle. Formula: Euclidean distance * multiplier");
        upgradeFurnaceFuelConsumption = ConfigHandler.getInt(CATEGORY_UPGRADE_FURNACE, "fuelConsumption", upgradeFurnaceFuelConsumption, "The fuel consumption per item to smelt items in the Furnace Turtle Upgrade (Minimum value: 10)");
        upgradeFurnaceFuelConsumption = Math.max(upgradeFurnaceFuelConsumption, 10);
        config.get(CATEGORY_UPGRADE_FURNACE, "fuelConsumption", upgradeFurnaceFuelConsumption).setToDefault();
        miniAntennaRange = ConfigHandler.getInt(CATEGORY_MINI_ANTENNA, "miniAntennaRange", miniAntennaRange, "The range in blocks the BitNet Mini Antenna can transmit");
        miniAntennaRangeStorm = ConfigHandler.getInt(CATEGORY_MINI_ANTENNA, "miniAntennaRangeStorm", miniAntennaRange, "The range in blocks the BitNet Mini Antenna can transmit during a storm");
        miniAntennaMessageDelay = ConfigHandler.getInt(CATEGORY_MINI_ANTENNA, "miniAntennaMessageDelay", miniAntennaMessageDelay, "The delay (in ticks) that the BitNet Mini Antenna takes to send a message per 100 block distance (rounded up).");
        userDensityMappings = config.getString("customDensity", CATEGORY_UPGRADE_DENSITY, userDensityMappings, "Add density mappings (semi-colon separated) for mod blocks to the Density Scanner in the format [modId]:[blockName]@[density]; \nsingle mapping example: MoarPeripherals:blockIronNote@5.45\nmulti-mapping example:  MoarPeripherals:blockIronNote@5.45;MoarPeripherals:blockChatBox@4.45").trim();
        if (userDensityMappings.toLowerCase().contains("minecraft:")) {
            throw new RuntimeException("Minecraft blocks cannot have a custom density mapping");
        }
        enablePrinterGfx = ConfigHandler.getBoolean(CATEGORY_RENDERER, "printerModel", false, "Whether or not to render items and blocks, related to the printer, normally or as models.");
        enableSonicGfx = ConfigHandler.getBoolean(CATEGORY_RENDERER, "sonicModel", "Whether or not to render the Sonic Screwdriver normally or as a model");
        debug = ConfigHandler.getBoolean("debug", "debugMessages", false, "Print debugging messages to the console. WARNING: Spammy, only enable this if theoriginalbit has asked you to");
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static boolean getBoolean(String cat, String key, boolean defBool, String desc) {
        return config.get(cat, key, defBool, desc).getBoolean(defBool);
    }

    private static boolean getBoolean(String cat, String key, String desc) {
        return ConfigHandler.getBoolean(cat, key, true, desc);
    }

    private static int getInt(String cat, String key, int defInt, String desc) {
        return config.get(cat, key, defInt, desc).getInt();
    }

    private static double getDouble(String cat, String key, double defDbl, String desc) {
        return config.get(cat, key, defDbl, desc).getDouble();
    }

    private static boolean getEnabled(String key) {
        return ConfigHandler.getBoolean(CATEGORY_ENABLED, key, String.format(ENABLEFORMAT, key));
    }

    private static boolean getUpgradeEnabled(String key) {
        return ConfigHandler.getBoolean(CATEGORY_UPGRADE, key, String.format(ENABLEFORMAT, key));
    }

    static {
        chatRangeSay = 64;
        chatRangeTell = 64;
        chatRangeRead = -1;
        chatSayRate = 1;
        noteRange = 64;
        keyboardRange = 16;
        antennaRange = 3000;
        antennaRangeStorm = 2400;
        antennaMessageDelay = 3;
        fuelMultiplier = 1.5;
        miniAntennaRange = 650;
        miniAntennaRangeStorm = 400;
        miniAntennaMessageDelay = 3;
        upgradeFurnaceFuelConsumption = 20;
        userDensityMappings = "";
    }
}

