/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.converter;

import com.google.common.collect.Maps;
import com.theoriginalbit.moarperipherals.api.peripheral.converter.ITypeConverter;
import cpw.mods.fml.common.registry.GameRegistry;
import dan200.computercraft.api.lua.LuaException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ConverterItemStack
implements ITypeConverter {
    @Override
    public Object fromLua(Object obj, Class<?> expected) throws LuaException {
        if (expected == ItemStack.class && obj instanceof Map) {
            Map m = (Map)obj;
            if (!m.containsKey("id")) {
                throw new LuaException("expected id for item");
            }
            String[] parts = ((String)m.get("id")).split(":");
            if (parts.length != 2) {
                throw new LuaException("invalid item id should be modId:blockName");
            }
            Item item = GameRegistry.findItem((String)parts[0], (String)parts[1]);
            if (item == null) {
                throw new LuaException("cannot find item for " + m.get("id"));
            }
            int quantity = ConverterItemStack.getIntValue(m, "qty", 1);
            int dmg = ConverterItemStack.getIntValue(m, "dmg", 0);
            return new ItemStack(item, quantity, dmg);
        }
        return null;
    }

    private static int getIntValue(Map<?, ?> map, String key, int _default) {
        Object value = map.get(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return _default;
    }

    @Override
    public Object toLua(Object obj) throws LuaException {
        if (obj instanceof ItemStack) {
            return ConverterItemStack.fillBasicProperties((ItemStack)obj);
        }
        return null;
    }

    private static Map<String, Object> fillBasicProperties(ItemStack stack) throws LuaException {
        HashMap map = Maps.newHashMap();
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
        if (id == null) {
            throw new LuaException(String.format("Invalid item stack: %s", stack));
        }
        map.put("id", id.toString());
        map.put("name", id.name);
        map.put("mod_id", id.modId);
        map.put("display_name", ConverterItemStack.getNameForItemStack(stack));
        map.put("raw_name", ConverterItemStack.getRawNameForStack(stack));
        map.put("qty", stack.field_77994_a);
        map.put("dmg", stack.func_77960_j());
        map.put("max_dmg", stack.func_77958_k());
        map.put("max_size", stack.func_77976_d());
        return map;
    }

    private static String getNameForItemStack(ItemStack is) {
        try {
            return is.func_82833_r();
        }
        catch (Exception ignored) {
            try {
                return is.func_77977_a();
            }
            catch (Exception exception) {
                return "unknown";
            }
        }
    }

    private static String getRawNameForStack(ItemStack is) {
        try {
            return is.func_77977_a().toLowerCase();
        }
        catch (Exception exception) {
            return "unknown";
        }
    }
}

