/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.theoriginalbit.moarperipherals.api.listener.IChatListener;
import com.theoriginalbit.moarperipherals.api.listener.ICommandListener;
import com.theoriginalbit.moarperipherals.api.listener.IDeathListener;
import com.theoriginalbit.moarperipherals.api.listener.IPlayerEventListener;
import com.theoriginalbit.moarperipherals.common.utils.LogUtils;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public final class ChatBoxHandler {
    public static final ChatBoxHandler instance = new ChatBoxHandler();
    private final ArrayList<IChatListener> chatListeners = Lists.newArrayList();
    private final ArrayList<IDeathListener> deathListeners = Lists.newArrayList();
    private final ArrayList<IPlayerEventListener> playerListeners = Lists.newArrayList();
    private final HashMap<String, ArrayList<ICommandListener>> commandListeners = Maps.newHashMap();

    public static void init() {
        if (Loader.isModLoaded((String)"OpenPeripheral")) {
            LogUtils.info("Detected OpenPeripheral-Addons installed. Registering the terminal glasses command as a ChatBox command so it is ignored by ChatBoxes.", new Object[0]);
            try {
                instance.addCommandListener(new ICommandListener(){
                    private static final String OPENPCOMMAND = "$$";

                    @Override
                    public String getToken() {
                        return OPENPCOMMAND;
                    }

                    @Override
                    public void onServerChatEvent(String message, EntityPlayer player) {
                    }
                });
            }
            catch (Exception e) {
                LogUtils.debug("Failed to register OpenPeripheral-Addon ChatBox command listener", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChatListener(IChatListener listener) {
        ArrayList<IChatListener> arrayList = this.chatListeners;
        synchronized (arrayList) {
            if (!this.chatListeners.contains(listener)) {
                this.chatListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChatListener(IChatListener listener) {
        ArrayList<IChatListener> arrayList = this.chatListeners;
        synchronized (arrayList) {
            if (this.chatListeners.contains(listener)) {
                this.chatListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeathListener(IDeathListener listener) {
        ArrayList<IDeathListener> arrayList = this.deathListeners;
        synchronized (arrayList) {
            if (!this.deathListeners.contains(listener)) {
                this.deathListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeathListener(IDeathListener listener) {
        ArrayList<IDeathListener> arrayList = this.deathListeners;
        synchronized (arrayList) {
            if (this.deathListeners.contains(listener)) {
                this.deathListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayerEventListener(IPlayerEventListener listener) {
        ArrayList<IPlayerEventListener> arrayList = this.playerListeners;
        synchronized (arrayList) {
            if (!this.playerListeners.contains(listener)) {
                this.playerListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayerEventListener(IPlayerEventListener listener) {
        ArrayList<IPlayerEventListener> arrayList = this.playerListeners;
        synchronized (arrayList) {
            if (this.playerListeners.contains(listener)) {
                this.playerListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommandListener(ICommandListener listener) throws Exception {
        String token = listener.getToken();
        HashMap<String, ArrayList<ICommandListener>> hashMap = this.commandListeners;
        synchronized (hashMap) {
            if (!this.commandListeners.containsKey(token)) {
                this.commandListeners.put(token, new ArrayList());
            }
            this.commandListeners.get(token).add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommandListener(ICommandListener listener) {
        String token = listener.getToken();
        HashMap<String, ArrayList<ICommandListener>> hashMap = this.commandListeners;
        synchronized (hashMap) {
            if (this.commandListeners.containsKey(token)) {
                this.commandListeners.get(token).remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onServerChatEvent(ServerChatEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Cloneable cloneable = this.commandListeners;
        synchronized (cloneable) {
            for (Map.Entry<String, ArrayList<ICommandListener>> entry : this.commandListeners.entrySet()) {
                String token = entry.getKey();
                if (!event.message.startsWith(token)) continue;
                for (ICommandListener listener : entry.getValue()) {
                    listener.onServerChatEvent(event.message.substring(token.length()).trim(), (EntityPlayer)event.player);
                    event.setCanceled(true);
                }
            }
        }
        if (event.isCanceled()) {
            return;
        }
        cloneable = this.chatListeners;
        synchronized (cloneable) {
            for (IChatListener listener : this.chatListeners) {
                listener.onServerChatEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        ArrayList<IDeathListener> arrayList = this.deathListeners;
        synchronized (arrayList) {
            for (IDeathListener listener : this.deathListeners) {
                listener.onDeathEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ArrayList<IPlayerEventListener> arrayList = this.playerListeners;
        synchronized (arrayList) {
            for (IPlayerEventListener listener : this.playerListeners) {
                listener.onPlayerJoin(event.player.getDisplayName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        ArrayList<IPlayerEventListener> arrayList = this.playerListeners;
        synchronized (arrayList) {
            for (IPlayerEventListener listener : this.playerListeners) {
                listener.onPlayerLeave(event.player.getDisplayName());
            }
        }
    }
}

