/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.handler;

import com.theoriginalbit.moarperipherals.common.config.ConfigHandler;
import com.theoriginalbit.moarperipherals.common.utils.LogUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class TickHandler {
    public static final TickHandler INSTANCE = new TickHandler();
    private static final ConcurrentLinkedQueue<FutureTask> callbacks = new ConcurrentLinkedQueue();

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.type == TickEvent.Type.SERVER) {
            FutureTask callback;
            while ((callback = callbacks.poll()) != null) {
                callback.run();
            }
        }
    }

    public static <T> Future<T> addTickCallback(Callable<T> callback) {
        FutureTask task = new FutureTask<T>((Callable)callback){

            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        this.get();
                    }
                }
                catch (Throwable t) {
                    LogUtils.warn("Exception while executing callback! " + this, new Object[0]);
                    t.printStackTrace();
                }
            }
        };
        callbacks.add(task);
        return task;
    }

    public static boolean shouldRegister() {
        return ConfigHandler.enableFireworkLauncher;
    }
}

