/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.item;

import com.theoriginalbit.moarperipherals.api.ITooltipInformer;
import com.theoriginalbit.moarperipherals.common.item.abstracts.ItemMoarP;
import com.theoriginalbit.moarperipherals.common.reference.Constants;
import com.theoriginalbit.moarperipherals.common.reference.ModInfo;
import com.theoriginalbit.moarperipherals.common.utils.NBTUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ItemInkCartridge
extends ItemMoarP
implements ITooltipInformer {
    private IIcon iconInkC;
    private IIcon iconInkM;
    private IIcon iconInkY;
    private IIcon iconInkK;
    private IIcon iconInkE;
    private static final String CONTENTS = "%s: %s";
    private static final String PERCENT = "%s: %s";

    public ItemInkCartridge() {
        super("inkCartridge");
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77637_a(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister registry) {
        this.iconInkC = registry.func_94245_a(ModInfo.RESOURCE_DOMAIN + ":inkCartridgeC");
        this.iconInkM = registry.func_94245_a(ModInfo.RESOURCE_DOMAIN + ":inkCartridgeM");
        this.iconInkY = registry.func_94245_a(ModInfo.RESOURCE_DOMAIN + ":inkCartridgeY");
        this.iconInkK = registry.func_94245_a(ModInfo.RESOURCE_DOMAIN + ":inkCartridgeK");
        this.iconInkE = registry.func_94245_a(ModInfo.RESOURCE_DOMAIN + ":inkCartridgeE");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        switch (meta) {
            case 0: {
                return this.iconInkC;
            }
            case 1: {
                return this.iconInkM;
            }
            case 2: {
                return this.iconInkY;
            }
            case 3: {
                return this.iconInkK;
            }
        }
        return this.iconInkE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformativeTooltip(ItemStack stack, EntityPlayer player, List<String> list, boolean bool) {
        int inkColor = ItemInkCartridge.getInkColor(stack);
        String inkName = ItemInkCartridge.getInkName(inkColor);
        if (inkColor > -1) {
            list.add(String.format("%s: %s", Constants.TOOLTIPS.INK_CONTENTS.getLocalised(), inkName));
            String percent = ItemInkCartridge.getInkPercent(stack);
            if (percent != null) {
                list.add(String.format("%s: %s", Constants.TOOLTIPS.INK_LEVEL.getLocalised(), percent));
            }
        } else {
            list.add(inkName);
        }
    }

    private static String getInkName(int inkColor) {
        Constants.LocalisationStore name;
        switch (inkColor) {
            case 0: {
                name = Constants.TOOLTIPS.INK_CYAN;
                break;
            }
            case 1: {
                name = Constants.TOOLTIPS.INK_MAGENTA;
                break;
            }
            case 2: {
                name = Constants.TOOLTIPS.INK_YELLOW;
                break;
            }
            case 3: {
                name = Constants.TOOLTIPS.INK_BLACK;
                break;
            }
            default: {
                name = Constants.TOOLTIPS.INK_EMPTY;
            }
        }
        return name.getLocalised();
    }

    public static int getInkColor(ItemStack stack) {
        NBTTagCompound tag = NBTUtils.getItemTag(stack);
        if (tag.func_74764_b("inkColor")) {
            return tag.func_74762_e("inkColor");
        }
        return -1;
    }

    public static String getInkPercent(ItemStack stack) {
        NBTTagCompound tag = NBTUtils.getItemTag(stack);
        if (tag.func_74764_b("inkLevel")) {
            float level = tag.func_74760_g("inkLevel");
            return (int)(level / 1000.0f * 100.0f) + "%";
        }
        return null;
    }
}

