/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.item;

import buildcraft.api.tools.IToolWrench;
import com.google.common.collect.ImmutableSet;
import com.theoriginalbit.moarperipherals.common.item.abstracts.ItemMoarP;
import com.theoriginalbit.moarperipherals.common.reference.Constants;
import com.theoriginalbit.moarperipherals.common.reference.ModInfo;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="buildcraft.api.tools.IToolWrench", modid="BuildCraft|Core")
public class ItemSonic
extends ItemMoarP
implements IToolWrench {
    private static final ImmutableSet<Class<? extends Block>> blacklist = ImmutableSet.of(BlockLever.class, BlockButton.class, BlockBed.class, BlockTorch.class);
    private IIcon iconTen;
    private IIcon iconEleven;

    public ItemSonic() {
        super("sonic");
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister registry) {
        this.iconTen = registry.func_94245_a(ModInfo.RESOURCE_DOMAIN + ":sonic10");
        this.iconEleven = registry.func_94245_a(ModInfo.RESOURCE_DOMAIN + ":sonic11");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return meta == 0 ? this.iconTen : this.iconEleven;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        if (block.func_149688_o() == Material.field_151575_d) {
            String message = EnumChatFormatting.RED + Constants.CHAT.SONIC_WOOD.getLocalised();
            player.func_146105_b((IChatComponent)new ChatComponentText(message));
            return true;
        }
        if (blacklist.contains(block.getClass())) {
            return false;
        }
        if (block instanceof BlockFurnace && side != 0 && side != 1) {
            if (player.func_70093_af()) {
                side = ForgeDirection.getOrientation((int)side).getOpposite().ordinal();
            }
            world.func_72921_c(x, y, z, side, 2);
            player.func_71038_i();
            return !world.field_72995_K;
        }
        if (block instanceof BlockStairs) {
            return this.rotateStairs(stack, player, world, x, y, z, side);
        }
        return this.rotate(block, player, world, x, y, z, side);
    }

    private boolean rotate(Block block, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (block.rotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)side))) {
            player.func_71038_i();
            return !world.field_72995_K;
        }
        return false;
    }

    private boolean rotateStairs(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z) & 4;
        if (player.func_70093_af()) {
            meta ^= 4;
        }
        switch (side) {
            case 2: {
                meta |= 2;
                break;
            }
            case 3: {
                meta |= 3;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                meta |= 1;
            }
        }
        world.func_72921_c(x, y, z, meta, 2);
        stack.func_77972_a(1, (EntityLivingBase)player);
        return true;
    }

    @Optional.Method(modid="BuildCraft|Core")
    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        return true;
    }

    @Optional.Method(modid="BuildCraft|Core")
    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        player.func_71038_i();
    }
}

