/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.item.block;

import com.theoriginalbit.moarperipherals.api.tile.IPairedDevice;
import com.theoriginalbit.moarperipherals.common.reference.Constants;
import com.theoriginalbit.moarperipherals.common.utils.ChatUtils;
import com.theoriginalbit.moarperipherals.common.utils.KeyboardUtils;
import com.theoriginalbit.moarperipherals.common.utils.LogUtils;
import com.theoriginalbit.moarperipherals.common.utils.NBTUtils;
import com.theoriginalbit.moarperipherals.common.utils.PairedUtils;
import com.theoriginalbit.moarperipherals.common.utils.WorldUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlockPaired
extends ItemBlock {
    public ItemBlockPaired(Block block) {
        super(block);
        this.func_77625_d(1);
        this.func_77655_b(block.func_149739_a());
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        if (super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, meta)) {
            IPairedDevice tile = WorldUtils.getTileEntity((IBlockAccess)world, x, y, z, IPairedDevice.class);
            this.setupTileEntity(stack, tile);
            return true;
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (WorldUtils.isServer(world) && !player.func_70093_af() && PairedUtils.isComputer(tile)) {
            if (!PairedUtils.isPairAllowed(tile)) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + Constants.CHAT.CHAT_REJECTED_PAIR.getLocalised()));
                return true;
            }
            int instanceId = PairedUtils.getInstanceId(tile);
            if (!PairedUtils.isOn(PairedUtils.getInstance(instanceId))) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + Constants.CHAT.CHAT_PAIR_POWER_REQUIRED.getLocalised()));
                return true;
            }
            LogUtils.debug("Computer at %d, %d, %d has been right-clicked, getting computer information", x, y, z);
            String desc = PairedUtils.getDescription(instanceId);
            ChunkCoordinates coordinates = PairedUtils.getInstanceLocation(instanceId);
            ChatUtils.sendChatToPlayer(player.getDisplayName(), Constants.CHAT.CHAT_PAIRED.getFormattedLocalised(desc));
            NBTUtils.setInteger(stack, "instanceId", instanceId);
            return true;
        }
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean details) {
        if (KeyboardUtils.isShiftKeyDown()) {
            if (this.containsTargetInfo(stack)) {
                int instanceId = NBTUtils.getInteger(stack, "instanceId");
                String desc = PairedUtils.getDescription(instanceId);
                list.add(EnumChatFormatting.GRAY + Constants.TOOLTIPS.PAIRED.getFormattedLocalised(desc));
            } else {
                list.add(EnumChatFormatting.ITALIC + Constants.TOOLTIPS.NOT_PAIRED.getLocalised());
            }
        } else {
            list.add(Constants.TOOLTIPS.SHIFT_INFO.getLocalised());
        }
    }

    private boolean setupTileEntity(ItemStack stack, IPairedDevice tile) {
        return this.containsTargetInfo(stack) && tile.configureTargetFromNbt(NBTUtils.getItemTag(stack));
    }

    private boolean containsTargetInfo(ItemStack stack) {
        return NBTUtils.hasTag(stack, "instanceId");
    }
}

