/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.network.message;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

class MessageGeneric
implements IMessage {
    public int[] intData;
    public byte[] byteData;
    public char[] charData;
    public float[] floatData;
    public double[] doubleData;
    public String[] stringData;
    public NBTTagCompound nbtData;

    MessageGeneric() {
    }

    public void toBytes(ByteBuf buf) {
        if (this.stringData != null) {
            buf.writeInt(this.stringData.length);
            for (String str : this.stringData) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)str);
            }
        } else {
            buf.writeInt(0);
        }
        if (this.intData != null) {
            buf.writeInt(this.intData.length);
            for (int i : this.intData) {
                buf.writeInt(i);
            }
        } else {
            buf.writeInt(0);
        }
        if (this.byteData != null) {
            buf.writeInt(this.byteData.length);
            buf.writeBytes(this.byteData);
        } else {
            buf.writeInt(0);
        }
        if (this.charData != null) {
            buf.writeInt(this.charData.length);
            for (char c : this.charData) {
                buf.writeChar((int)c);
            }
        } else {
            buf.writeInt(0);
        }
        if (this.floatData != null) {
            buf.writeInt(this.floatData.length);
            for (float f : this.floatData) {
                buf.writeFloat(f);
            }
        } else {
            buf.writeInt(0);
        }
        if (this.doubleData != null) {
            buf.writeInt(this.doubleData.length);
            for (double d : this.doubleData) {
                buf.writeDouble(d);
            }
        } else {
            buf.writeInt(0);
        }
        if (this.nbtData != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbtData);
        } else {
            buf.writeBoolean(false);
        }
    }

    public void fromBytes(ByteBuf buf) {
        boolean wasNBT;
        int nStr = buf.readInt();
        this.stringData = new String[nStr];
        if (nStr > 0) {
            for (int i = 0; i < nStr; ++i) {
                this.stringData[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
            }
        }
        int nInt = buf.readInt();
        this.intData = new int[nInt];
        if (nInt > 0) {
            for (int i = 0; i < nInt; ++i) {
                this.intData[i] = buf.readInt();
            }
        }
        int nByte = buf.readInt();
        this.byteData = new byte[nByte];
        if (nByte > 0) {
            buf.readBytes(this.byteData);
        }
        int nChar = buf.readInt();
        this.charData = new char[nChar];
        if (nChar > 0) {
            for (int i = 0; i < nChar; ++i) {
                this.charData[i] = buf.readChar();
            }
        }
        int nFloat = buf.readInt();
        this.floatData = new float[nFloat];
        if (nFloat > 0) {
            for (int i = 0; i < nFloat; ++i) {
                this.floatData[i] = buf.readFloat();
            }
        }
        int nDouble = buf.readInt();
        this.doubleData = new double[nDouble];
        if (nDouble > 0) {
            for (int i = 0; i < nDouble; ++i) {
                this.doubleData[i] = buf.readDouble();
            }
        }
        if (wasNBT = buf.readBoolean()) {
            this.nbtData = ByteBufUtils.readTag((ByteBuf)buf);
        }
    }
}

