/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.reference;

import com.theoriginalbit.moarperipherals.common.reference.ModInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public final class Constants {

    public static final class TextureStore {
        private final String pathToResource;
        private final ResourceLocation resource;

        private TextureStore(String path) {
            this(path, true);
        }

        private TextureStore(String path, boolean load) {
            this.pathToResource = path + ".png";
            this.resource = load ? new ResourceLocation(ModInfo.RESOURCE_DOMAIN, this.pathToResource) : null;
        }

        public final ResourceLocation getResourceLocation() {
            return this.resource;
        }

        public final String getPath() {
            return this.pathToResource;
        }
    }

    public static final class LocalisationStore {
        private final String rawName;

        private LocalisationStore(String name) {
            this.rawName = name;
        }

        public String getLocalised() {
            return StatCollector.func_74838_a((String)this.rawName);
        }

        public String getFormattedLocalised(Object ... args) {
            return StatCollector.func_74837_a((String)this.rawName, (Object[])args);
        }
    }

    public static final class TEXTURES_MODEL {
        public static final TextureStore INK_CARTRIDGE_C = new TextureStore("textures/models/items/inkCartridge/InkCartridgeC");
        public static final TextureStore INK_CARTRIDGE_M = new TextureStore("textures/models/items/inkCartridge/InkCartridgeM");
        public static final TextureStore INK_CARTRIDGE_Y = new TextureStore("textures/models/items/inkCartridge/InkCartridgeY");
        public static final TextureStore INK_CARTRIDGE_K = new TextureStore("textures/models/items/inkCartridge/InkCartridgeK");
        public static final TextureStore INK_CARTRIDGE_E = new TextureStore("textures/models/items/inkCartridge/InkCartridgeE");
        public static final TextureStore SONIC_10_0 = new TextureStore("textures/models/items/sonic/Sonic10_0");
        public static final TextureStore SONIC_10_1 = new TextureStore("textures/models/items/sonic/Sonic10_1");
        public static final TextureStore SONIC_10_TIPON = new TextureStore("textures/models/items/sonic/Sonic10_On");
        public static final TextureStore SONIC_10_TIPOFF = new TextureStore("textures/models/items/sonic/Sonic10_Off");
        public static final TextureStore SONIC_11_0 = new TextureStore("textures/models/items/sonic/Sonic11_0");
        public static final TextureStore SONIC_11_1 = new TextureStore("textures/models/items/sonic/Sonic11_1");
        public static final TextureStore SONIC_11_TIPON = new TextureStore("textures/models/items/sonic/Sonic11_On");
        public static final TextureStore SONIC_11_TIPOFF = new TextureStore("textures/models/items/sonic/Sonic11_Off");
        public static final TextureStore ANTENNA = new TextureStore("textures/models/blocks/antenna/Antenna");
    }

    public static final class CHAT {
        public static final LocalisationStore CHAT_PAIRED = new LocalisationStore("moarperipherals.chat.paired");
        public static final LocalisationStore CHAT_NOT_PAIRED = new LocalisationStore("moarperipherals.chat.notPaired");
        public static final LocalisationStore CHAT_REJECTED_PAIR = new LocalisationStore("moarperipherals.chat.pairFailRejected");
        public static final LocalisationStore CHAT_PAIR_POWER_REQUIRED = new LocalisationStore("moarperipherals.chat.pairFailPowerOff");
        public static final LocalisationStore SONIC_WOOD = new LocalisationStore("moarperipherals.chat.sonic.wood");
    }

    public static final class UPGRADE {
        public static final LocalisationStore CHATBOX = new LocalisationStore("upgrade.moarperipherals:adjective.chatbox");
        public static final LocalisationStore IRONNOTE = new LocalisationStore("upgrade.moarperipherals:adjective.ironnote");
        public static final LocalisationStore SHEARS = new LocalisationStore("upgrade.moarperipherals:adjective.shears");
        public static final LocalisationStore COMPASS = new LocalisationStore("upgrade.moarperipherals:adjective.compass");
        public static final LocalisationStore FURNACE = new LocalisationStore("upgrade.moarperipherals:adjective.furnace");
        public static final LocalisationStore SOLAR = new LocalisationStore("upgrade.moarperipherals:adjective.solar");
        public static final LocalisationStore IGNITER = new LocalisationStore("upgrade.moarperipherals:adjective.pyro");
        public static final LocalisationStore FEEDER = new LocalisationStore("upgrade.moarperipherals:adjective.feeder");
        public static final LocalisationStore DENSITYSCANNER = new LocalisationStore("upgrade.moarperipherals:adjective.densityscanner");
    }

    public static final class TOOLTIPS {
        public static final LocalisationStore PAIRED = new LocalisationStore("tooltip.moarperipherals.pairable.paired");
        public static final LocalisationStore NOT_PAIRED = new LocalisationStore("tooltip.moarperipherals.pairable.notPaired");
        public static final LocalisationStore SHIFT_INFO = new LocalisationStore("tooltip.moarperipherals.generic.information");
        public static final LocalisationStore INK_CONTENTS = new LocalisationStore("tooltip.moarperipherals.inkCartridge.contents");
        public static final LocalisationStore INK_LEVEL = new LocalisationStore("tooltip.moarperipherals.inkCartridge.level");
        public static final LocalisationStore INK_CYAN = new LocalisationStore("tooltip.moarperipherals.inkCartridge.ink.cyan");
        public static final LocalisationStore INK_MAGENTA = new LocalisationStore("tooltip.moarperipherals.inkCartridge.ink.magenta");
        public static final LocalisationStore INK_YELLOW = new LocalisationStore("tooltip.moarperipherals.inkCartridge.ink.yellow");
        public static final LocalisationStore INK_BLACK = new LocalisationStore("tooltip.moarperipherals.inkCartridge.ink.black");
        public static final LocalisationStore INK_EMPTY = new LocalisationStore("tooltip.moarperipherals.inkCartridge.ink.empty");
    }

    public static final class GUI {
        public static final LocalisationStore KEYBOARD_EXIT = new LocalisationStore("moarperipherals.gui.keyboard.exit");
        public static final LocalisationStore FIREWORKS = new LocalisationStore("tile.moarperipherals:fireworks.name");
        public static final LocalisationStore CRAFTER = new LocalisationStore("tile.moarperipherals:crafter.name");
        public static final LocalisationStore PRINTER = new LocalisationStore("tile.moarperipherals:printer.name");
    }

    public static final class RENDER_ID {
        public static int ANTENNA = -1;
        public static int ANTENNA_CTRLR = -1;
    }
}

