/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.registry;

import com.google.common.collect.Lists;
import com.theoriginalbit.moarperipherals.api.bitnet.BitNetMessage;
import com.theoriginalbit.moarperipherals.api.bitnet.IBitNetCompliant;
import com.theoriginalbit.moarperipherals.common.config.ConfigHandler;
import com.theoriginalbit.moarperipherals.common.utils.LogUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public final class BitNetRegistry {
    private static final ArrayList<IBitNetCompliant> towers = Lists.newArrayList();
    private static final ConcurrentLinkedQueue<DelayedMessage> messageQueue = new ConcurrentLinkedQueue();
    private static int nextId = 0;

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<DelayedMessage> it = messageQueue.iterator();
            while (it.hasNext()) {
                DelayedMessage message = it.next();
                if (!message.tick()) continue;
                it.remove();
            }
        }
    }

    public static int registerCompliance(IBitNetCompliant tile) {
        LogUtils.debug("BitNet registerTower invoked, already contains tower: " + towers.contains(tile), new Object[0]);
        if (!towers.contains(tile)) {
            towers.add(tile);
            return nextId++;
        }
        return -1;
    }

    public static void deregisterCompliance(IBitNetCompliant tile) {
        LogUtils.debug("BitNet deregisterTower invoked, tower registered: " + towers.contains(tile), new Object[0]);
        if (towers.contains(tile)) {
            towers.remove(tile);
        }
    }

    public static void transmit(IBitNetCompliant sender, BitNetMessage payload) {
        Vec3 sendLocation = sender.getWorldPosition();
        World sendWorld = sender.getWorld();
        boolean isStorming = sendWorld.func_72896_J() && sendWorld.func_72911_I();
        for (IBitNetCompliant receiver : towers) {
            int range;
            if (receiver.getWorld() != sendWorld) continue;
            Vec3 towerLocation = receiver.getWorldPosition();
            double distance = Math.sqrt(sendLocation.func_72445_d(towerLocation.field_72450_a, towerLocation.field_72448_b, towerLocation.field_72449_c));
            int n = range = isStorming ? receiver.getReceiveRangeDuringStorm() : receiver.getReceiveRange();
            if (!(distance > 0.0) || !(distance <= (double)range)) continue;
            messageQueue.add(new DelayedMessage(receiver, new BitNetMessage(payload).addDistance(distance), distance));
        }
    }

    private static final class DelayedMessage {
        private final IBitNetCompliant receiver;
        private final BitNetMessage payload;
        private int sendDelay;

        public DelayedMessage(IBitNetCompliant tower, BitNetMessage message, double distance) {
            this.receiver = tower;
            this.payload = message;
            this.sendDelay = (int)(Math.ceil(distance / 100.0) * (double)ConfigHandler.antennaMessageDelay);
            LogUtils.debug(String.format("Created %02d tick delayed message, payload=%s", this.sendDelay, this.payload.toString()), new Object[0]);
        }

        public boolean tick() {
            if (--this.sendDelay <= 0) {
                LogUtils.debug(String.format("Ticks expired for %s sending message", this.payload.getMessageId()), new Object[0]);
                this.receiver.receive(this.payload);
                return true;
            }
            return false;
        }
    }
}

