/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.registry;

import com.google.common.collect.Lists;
import com.theoriginalbit.moarperipherals.common.config.ConfigHandler;
import com.theoriginalbit.moarperipherals.common.upgrade.UpgradeChatBox;
import com.theoriginalbit.moarperipherals.common.upgrade.UpgradeCompass;
import com.theoriginalbit.moarperipherals.common.upgrade.UpgradeDensityScanner;
import com.theoriginalbit.moarperipherals.common.upgrade.UpgradeFeeder;
import com.theoriginalbit.moarperipherals.common.upgrade.UpgradeFurnace;
import com.theoriginalbit.moarperipherals.common.upgrade.UpgradeIgniter;
import com.theoriginalbit.moarperipherals.common.upgrade.UpgradeIronNote;
import com.theoriginalbit.moarperipherals.common.upgrade.UpgradeShears;
import com.theoriginalbit.moarperipherals.common.upgrade.UpgradeSolar;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import java.util.ArrayList;

public class UpgradeRegistry {
    public static final UpgradeRegistry INSTANCE = new UpgradeRegistry();
    public static final ArrayList<ITurtleUpgrade> UPGRADES = Lists.newArrayList();

    private UpgradeRegistry() {
    }

    public final void register() {
        if (ConfigHandler.enableChatBox) {
            UpgradeRegistry.register(new UpgradeChatBox());
        }
        if (ConfigHandler.enableIronNote) {
            UpgradeRegistry.register(new UpgradeIronNote());
        }
        if (ConfigHandler.enableUpgradeShears) {
            UpgradeRegistry.register(new UpgradeShears());
        }
        if (ConfigHandler.enableUpgradeCompass) {
            UpgradeRegistry.register(new UpgradeCompass());
        }
        if (ConfigHandler.enableUpgradeSolar) {
            UpgradeRegistry.register(new UpgradeSolar());
        }
        if (ConfigHandler.enableUpgradeIgniter) {
            UpgradeRegistry.register(new UpgradeIgniter());
        }
        if (ConfigHandler.enableUpgradeFurnace) {
            UpgradeRegistry.register(new UpgradeFurnace());
        }
        if (ConfigHandler.enableUpgradeFeeder) {
            UpgradeRegistry.register(new UpgradeFeeder());
        }
        if (ConfigHandler.enableUpgradeOreScanner) {
            UpgradeRegistry.register(new UpgradeDensityScanner());
        }
    }

    private static void register(ITurtleUpgrade upgrade) {
        ComputerCraftAPI.registerTurtleUpgrade((ITurtleUpgrade)upgrade);
        UPGRADES.add(upgrade);
    }
}

