/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.tile;

import com.google.common.collect.Lists;
import com.theoriginalbit.moarperipherals.MoarPeripherals;
import com.theoriginalbit.moarperipherals.api.bitnet.BitNetMessage;
import com.theoriginalbit.moarperipherals.api.bitnet.IBitNetCompliant;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.Computers;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.LuaPeripheral;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.LuaFunction;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.MultiReturn;
import com.theoriginalbit.moarperipherals.api.tile.aware.IBreakAwareTile;
import com.theoriginalbit.moarperipherals.api.tile.aware.IPlaceAwareTile;
import com.theoriginalbit.moarperipherals.common.block.BlockAntenna;
import com.theoriginalbit.moarperipherals.common.block.BlockAntennaCell;
import com.theoriginalbit.moarperipherals.common.block.BlockAntennaController;
import com.theoriginalbit.moarperipherals.common.block.BlockAntennaMiniCell;
import com.theoriginalbit.moarperipherals.common.chunk.ChunkLoadingCallback;
import com.theoriginalbit.moarperipherals.common.chunk.IChunkLoader;
import com.theoriginalbit.moarperipherals.common.chunk.TicketManager;
import com.theoriginalbit.moarperipherals.common.config.ConfigHandler;
import com.theoriginalbit.moarperipherals.common.registry.BitNetRegistry;
import com.theoriginalbit.moarperipherals.common.tile.abstracts.TileMoarP;
import com.theoriginalbit.moarperipherals.common.utils.LogUtils;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

@LuaPeripheral(value="bitnet_tower")
public class TileAntennaController
extends TileMoarP
implements IPlaceAwareTile,
IBreakAwareTile,
IBitNetCompliant,
IChunkLoader {
    private static final String EVENT_BITNET = "bitnet_message";
    private final ArrayList<UUID> receivedMessages = Lists.newArrayList();
    private ForgeChunkManager.Ticket chunkTicket;
    private boolean complete = false;
    private boolean registered = false;
    @Computers.List
    public ArrayList<IComputerAccess> computers;

    public double func_145833_n() {
        return 65536.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.complete = tag.func_74767_n("structureComplete");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("structureComplete", this.complete);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.checkStructure();
    }

    public void func_145845_h() {
        if (this.complete && !this.registered) {
            this.registerTower();
        }
    }

    public void onBlockAdded() {
        this.complete = false;
        this.registered = false;
        this.checkStructure();
    }

    public void onBlockRemoved() {
        for (int y = 1; y < 16; ++y) {
            if (!(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + y, this.field_145849_e) instanceof BlockAntenna)) continue;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d + y, this.field_145849_e, 0, 3);
        }
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
        this.unregisterTower();
        this.complete = false;
    }

    @LuaFunction
    public boolean isTowerComplete() {
        return this.complete;
    }

    @LuaFunction
    @MultiReturn
    public Object[] transmit(Object payload) {
        if (this.isTowerComplete()) {
            BitNetRegistry.transmit(this, new BitNetMessage(payload));
            return new Object[]{true};
        }
        return new Object[]{false, "BitNet Communications Tower incomplete."};
    }

    @Override
    public void onPlaced(EntityLivingBase entity, ItemStack stack, int x, int y, int z) {
        this.onBlockAdded();
    }

    @Override
    public void onBreak(int x, int y, int z) {
        this.onBlockRemoved();
    }

    @Override
    public ChunkCoordIntPair getChunkCoord() {
        return new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4);
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public Vec3 getWorldPosition() {
        return Vec3.func_72443_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    @Override
    public void receive(BitNetMessage message) {
        if (!this.receivedMessages.contains(message.getMessageId())) {
            if (this.computers != null && this.computers.size() > 0) {
                LogUtils.debug(String.format("BitNet Comms Tower at %d %d %d has computer(s) connected, queueing BitNet message for them to handle...", this.field_145851_c, this.field_145848_d, this.field_145849_e), new Object[0]);
                for (IComputerAccess comp : this.computers) {
                    comp.queueEvent(EVENT_BITNET, new Object[]{comp.getAttachmentName(), message.getPayload(), message.getDistanceTravelled()});
                }
            } else {
                LogUtils.debug(String.format("BitNet Comms Tower at %d %d %d has no computer(s) connected, acting as a repeating tower...", this.field_145851_c, this.field_145848_d, this.field_145849_e), new Object[0]);
                BitNetRegistry.transmit(this, message);
            }
            this.receivedMessages.add(message.getMessageId());
        } else {
            LogUtils.debug(String.format("BitNet Communications Tower at %d %d %d received a previously received message...", this.field_145851_c, this.field_145848_d, this.field_145849_e), new Object[0]);
        }
    }

    @Override
    public int getReceiveRange() {
        return ConfigHandler.antennaRange;
    }

    @Override
    public int getReceiveRangeDuringStorm() {
        return ConfigHandler.antennaRangeStorm;
    }

    private void checkStructure() {
        int y;
        for (y = 1; y < 13; ++y) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + y, this.field_145849_e);
            if (block instanceof BlockAntenna && !(block instanceof BlockAntennaCell) && !(block instanceof BlockAntennaController) && !(block instanceof BlockAntennaMiniCell)) continue;
            return;
        }
        if (!(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 13, this.field_145849_e) instanceof BlockAntennaMiniCell)) {
            return;
        }
        if (!(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 14, this.field_145849_e) instanceof BlockAntennaCell)) {
            return;
        }
        if (!(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 15, this.field_145849_e) instanceof BlockAntennaCell)) {
            return;
        }
        for (y = 1; y < 16; ++y) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d + y, this.field_145849_e, 1, 3);
        }
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
        this.complete = true;
    }

    private void registerTower() {
        if (!this.field_145850_b.field_72995_K) {
            BitNetRegistry.registerCompliance(this);
            if (ConfigHandler.antennaKeepsChunkLoaded && this.chunkTicket == null) {
                this.chunkTicket = ChunkLoadingCallback.ticketList.remove(this);
                if (this.chunkTicket == null) {
                    LogUtils.info(String.format("Requesting chunk loading ticket for BitNet Communications Tower at %d %d %d", this.field_145851_c, this.field_145848_d, this.field_145849_e), new Object[0]);
                    this.chunkTicket = TicketManager.requestTicket(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    if (this.chunkTicket.isPlayerTicket()) {
                        LogUtils.warn(String.format("The returned ticket is a player ticket for player %s", this.chunkTicket.getPlayerName()), new Object[0]);
                    }
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)this.getChunkCoord());
                } else {
                    LogUtils.info(String.format("A chunk loading ticket was found from server start for the BitNet Communications Tower at %d %d %d", this.field_145851_c, this.field_145848_d, this.field_145849_e), new Object[0]);
                }
            }
        }
        this.registered = true;
    }

    private void unregisterTower() {
        if (!this.field_145850_b.field_72995_K) {
            BitNetRegistry.deregisterCompliance(this);
            if (ConfigHandler.antennaKeepsChunkLoaded && this.chunkTicket != null && !MoarPeripherals.isServerStopping) {
                LogUtils.info(String.format("Releasing Ticket for the BitNet Communications Tower at %d %d %d", this.field_145851_c, this.field_145848_d, this.field_145849_e), new Object[0]);
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)this.getChunkCoord());
                TicketManager.releaseTicket(this.chunkTicket);
                this.chunkTicket = null;
            }
        }
        this.registered = false;
    }
}

