/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.tile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.theoriginalbit.moarperipherals.api.listener.IChatListener;
import com.theoriginalbit.moarperipherals.api.listener.ICommandListener;
import com.theoriginalbit.moarperipherals.api.listener.IDeathListener;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.Computers;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.LuaPeripheral;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.LuaFunction;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.MultiReturn;
import com.theoriginalbit.moarperipherals.api.tile.aware.IBreakAwareTile;
import com.theoriginalbit.moarperipherals.common.config.ConfigHandler;
import com.theoriginalbit.moarperipherals.common.handler.ChatBoxHandler;
import com.theoriginalbit.moarperipherals.common.tile.abstracts.TileMoarP;
import com.theoriginalbit.moarperipherals.common.utils.ChatUtils;
import com.theoriginalbit.moarperipherals.common.utils.LogUtils;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import org.apache.commons.lang3.ArrayUtils;

@LuaPeripheral(value="chatbox")
public class TileChatBox
extends TileMoarP
implements IBreakAwareTile,
IChatListener,
IDeathListener,
ICommandListener {
    private static final String ERROR_TOO_MANY = "too many messages (max %d per second)";
    private static final String ERROR_RANGE_FORMAT = "range must be between -1 (infinite) and %d inclusive";
    private static final String ERROR_RANGE_GENERIC = "range must be -1 (infinite) or higher";
    private static final String ERROR_LABEL = "label must be no more than %d characters long";
    private static final String EVENT_CHAT = "chat_message";
    private static final String EVENT_DEATH = "death_message";
    private static final String EVENT_COMMAND = "chatbox_command";
    private static final String COMMAND_TOKEN = "##";
    private static final int MAX_LABEL_LENGTH = 20;
    private static final int TICKER_INTERVAL = 20;
    private int ticker = 0;
    private int count = 0;
    private boolean registered = false;
    private String label = "";
    private int rangeSay = ConfigHandler.chatRangeSay;
    private int rangeTell = ConfigHandler.chatRangeTell;
    private int rangeRead = ConfigHandler.chatRangeRead;
    @Computers.List
    public ArrayList<IComputerAccess> computers;

    @LuaFunction
    public boolean say(String message) throws Exception {
        Preconditions.checkArgument((this.count++ <= ConfigHandler.chatSayRate ? 1 : 0) != 0, (String)ERROR_TOO_MANY, (Object[])new Object[]{ConfigHandler.chatSayRate});
        String[] usernames = this.getPlayerUsernames();
        if (usernames.length == 0) {
            return false;
        }
        ChatUtils.sendChatToPlayer(usernames, this.buildMessage(message, false));
        return true;
    }

    @LuaFunction
    public boolean tell(String username, String message) throws Exception {
        Preconditions.checkArgument((this.count++ <= ConfigHandler.chatSayRate ? 1 : 0) != 0, (String)ERROR_TOO_MANY, (Object[])new Object[]{ConfigHandler.chatSayRate});
        ServerConfigurationManager scm = MinecraftServer.func_71276_C().func_71203_ab();
        if (this.rangeTell == 0 || this.rangeTell > 0 && !this.entityInRange((Entity)scm.func_152612_a(username), this.rangeTell)) {
            return false;
        }
        ChatUtils.sendChatToPlayer(username, this.buildMessage(message, true));
        return true;
    }

    @LuaFunction
    @MultiReturn
    public Object[] setLabel(String str) {
        if ((str = ChatAllowedCharacters.func_71565_a((String)str.trim())).length() > 20) {
            return new Object[]{false, String.format(ERROR_LABEL, 20)};
        }
        this.label = str;
        return new Object[]{true};
    }

    @LuaFunction
    public String getLabel() {
        return this.label;
    }

    @LuaFunction
    @MultiReturn
    public Object[] setSayRange(int range) {
        Object[] valid = this.validateRange(range, ConfigHandler.chatRangeSay);
        if (((Boolean)valid[0]).booleanValue()) {
            this.rangeSay = range;
        }
        return valid;
    }

    @LuaFunction
    public int getSayRange() {
        return this.rangeSay;
    }

    @LuaFunction
    public int getMaxSayRange() {
        return ConfigHandler.chatRangeSay;
    }

    @LuaFunction
    @MultiReturn
    public Object[] setTellRange(int range) {
        Object[] valid = this.validateRange(range, ConfigHandler.chatRangeTell);
        if (((Boolean)valid[0]).booleanValue()) {
            this.rangeTell = range;
        }
        return valid;
    }

    @LuaFunction
    public int getTellRange() {
        return this.rangeTell;
    }

    @LuaFunction
    public int getMaxTellRange() {
        return ConfigHandler.chatRangeTell;
    }

    @LuaFunction
    @MultiReturn
    public Object[] setReadRange(int range) {
        Object[] valid = this.validateRange(range, ConfigHandler.chatRangeRead);
        if (((Boolean)valid[0]).booleanValue()) {
            this.rangeRead = range;
        }
        return valid;
    }

    @LuaFunction
    public int getReadRange() {
        return this.rangeRead;
    }

    @LuaFunction
    public int getMaxReadRange() {
        return ConfigHandler.chatRangeRead;
    }

    public void func_145845_h() {
        if (++this.ticker > 20) {
            this.count = 0;
            this.ticker = 0;
        }
        if (!this.field_145850_b.field_72995_K && !this.registered) {
            ChatBoxHandler.instance.addChatListener(this);
            ChatBoxHandler.instance.addDeathListener(this);
            try {
                ChatBoxHandler.instance.addCommandListener(this);
            }
            catch (Exception e) {
                LogUtils.info(String.format("Failed to register command listener for ChatBox at %d %d %d", this.field_145851_c, this.field_145848_d, this.field_145849_e), new Object[0]);
                e.printStackTrace();
            }
            this.registered = true;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.unload();
    }

    @Override
    public void onBreak(int x, int y, int z) {
        this.unload();
    }

    @Override
    public void onServerChatEvent(ServerChatEvent event) {
        if (this.rangeRead < 0 || this.entityInRange((Entity)event.player, this.rangeRead)) {
            this.computerQueueEvent(EVENT_CHAT, event.player.getDisplayName(), event.message);
        }
    }

    @Override
    public void onDeathEvent(LivingDeathEvent event) {
        if (event.entity instanceof EntityPlayerMP) {
            Entity ent;
            DamageSource source = event.source;
            String killer = null;
            if (source instanceof EntityDamageSource && (ent = source.func_76346_g()) != null) {
                killer = ent.func_70005_c_();
            }
            if (this.rangeRead < 0 || this.entityInRange(event.entity, this.rangeRead)) {
                this.computerQueueEvent(EVENT_DEATH, event.entity.func_70005_c_(), source.func_76355_l(), killer);
            }
        }
    }

    @Override
    public String getToken() {
        return COMMAND_TOKEN;
    }

    @Override
    public void onServerChatEvent(String message, EntityPlayer player) {
        if (this.rangeRead < 0 || this.entityInRange((Entity)player, this.rangeRead)) {
            this.computerQueueEvent(EVENT_COMMAND, player.getDisplayName(), message);
        }
    }

    protected void computerQueueEvent(String event, Object ... args) {
        if (this.computers == null || this.computers.isEmpty()) {
            return;
        }
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent(event, ArrayUtils.add((Object[])args, (int)0, (Object)computer.getAttachmentName()));
        }
    }

    private void unload() {
        if (!this.field_145850_b.field_72995_K) {
            ChatBoxHandler.instance.removeChatListener(this);
            ChatBoxHandler.instance.removeDeathListener(this);
            ChatBoxHandler.instance.removeCommandListener(this);
        }
    }

    private Object[] validateRange(int range, int server) {
        if (range < -1) {
            return new Object[]{false, server != -1 ? String.format(ERROR_RANGE_FORMAT, server) : ERROR_RANGE_GENERIC};
        }
        if (range == -1 && server != -1) {
            return new Object[]{false, String.format(ERROR_RANGE_FORMAT, server)};
        }
        if (range > server && server != -1) {
            return new Object[]{false, String.format(ERROR_RANGE_FORMAT, server)};
        }
        return new Object[]{true};
    }

    private boolean entityInRange(Entity entity, int range) {
        return entity != null && entity.func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= (double)range;
    }

    private String[] getPlayerUsernames() {
        ServerConfigurationManager scm = MinecraftServer.func_71276_C().func_71203_ab();
        String[] playerNames = scm.func_72369_d();
        if (this.rangeSay == 0) {
            return new String[0];
        }
        if (this.rangeSay > 0) {
            ArrayList names = Lists.newArrayList();
            for (String s : playerNames) {
                if (!this.entityInRange((Entity)scm.func_152612_a(s), this.rangeSay)) continue;
                names.add(s);
            }
            return names.toArray(new String[names.size()]);
        }
        return playerNames;
    }

    private String buildMessage(String msg, boolean pm) {
        return "[" + (this.label.isEmpty() ? "ChatBox" : this.label) + (ConfigHandler.displayChatBoxCoords ? String.format(" (%d,%d,%d)", this.field_145851_c, this.field_145848_d, this.field_145849_e) : "") + "] " + (pm ? "[PM] " : "") + msg;
    }
}

