/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.tile;

import com.theoriginalbit.moarperipherals.api.listener.IChatListener;
import com.theoriginalbit.moarperipherals.api.listener.ICommandListener;
import com.theoriginalbit.moarperipherals.api.listener.IDeathListener;
import com.theoriginalbit.moarperipherals.api.listener.IPlayerEventListener;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.Computers;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.LuaPeripheral;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.LuaFunction;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.MultiReturn;
import com.theoriginalbit.moarperipherals.api.tile.aware.IBreakAwareTile;
import com.theoriginalbit.moarperipherals.common.config.ConfigHandler;
import com.theoriginalbit.moarperipherals.common.handler.ChatBoxHandler;
import com.theoriginalbit.moarperipherals.common.tile.abstracts.TileMoarP;
import com.theoriginalbit.moarperipherals.common.utils.ChatUtils;
import com.theoriginalbit.moarperipherals.common.utils.LogUtils;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import org.apache.commons.lang3.ArrayUtils;

@LuaPeripheral(value="chatbox_admin")
public class TileChatBoxAdmin
extends TileMoarP
implements IBreakAwareTile,
IChatListener,
IDeathListener,
ICommandListener,
IPlayerEventListener {
    private static final String EVENT_CHAT = "chat_message";
    private static final String EVENT_DEATH = "death_message";
    private static final String EVENT_JOIN = "player_join";
    private static final String EVENT_LEAVE = "player_leave";
    private static final String EVENT_COMMAND = "chatbox_command";
    private static final String COMMAND_TOKEN = "##";
    private static final int MAX_LABEL_LENGTH = 20;
    private boolean registered = false;
    private String label = "";
    @Computers.List
    public ArrayList<IComputerAccess> computers;

    @LuaFunction
    public boolean say(String message) throws Exception {
        ServerConfigurationManager scm = MinecraftServer.func_71276_C().func_71203_ab();
        String[] playerNames = scm.func_72369_d();
        if (playerNames.length == 0) {
            return false;
        }
        ChatUtils.sendChatToPlayer(playerNames, this.buildMessage(message, false));
        return true;
    }

    @LuaFunction
    public boolean tell(String username, String message) throws Exception {
        ServerConfigurationManager scm = MinecraftServer.func_71276_C().func_71203_ab();
        if (scm.func_152612_a(username) == null) {
            return false;
        }
        ChatUtils.sendChatToPlayer(username, this.buildMessage(message, true));
        return true;
    }

    @LuaFunction
    @MultiReturn
    public Object[] setLabel(String str) {
        if ((str = ChatAllowedCharacters.func_71565_a((String)str.trim())).length() > 20) {
            return new Object[]{false, ""};
        }
        this.label = str;
        return new Object[]{true};
    }

    @LuaFunction
    public String getLabel() {
        return this.label;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && !this.registered) {
            ChatBoxHandler.instance.addChatListener(this);
            ChatBoxHandler.instance.addDeathListener(this);
            ChatBoxHandler.instance.addPlayerEventListener(this);
            try {
                ChatBoxHandler.instance.addCommandListener(this);
            }
            catch (Exception e) {
                LogUtils.info(String.format("Failed to register command listener for ChatBox at %d %d %d", this.field_145851_c, this.field_145848_d, this.field_145849_e), new Object[0]);
                e.printStackTrace();
            }
            this.registered = true;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.unload();
    }

    @Override
    public void onBreak(int x, int y, int z) {
        this.unload();
    }

    @Override
    public void onServerChatEvent(ServerChatEvent event) {
        this.computerQueueEvent(EVENT_CHAT, event.player.getDisplayName(), event.message);
    }

    @Override
    public void onDeathEvent(LivingDeathEvent event) {
        if (event.entity instanceof EntityPlayerMP) {
            Entity ent;
            DamageSource source = event.source;
            String killer = null;
            if (source instanceof EntityDamageSource && (ent = source.func_76346_g()) != null) {
                killer = ent.func_70005_c_();
            }
            this.computerQueueEvent(EVENT_DEATH, event.entity.func_70005_c_(), source.func_76355_l(), killer);
        }
    }

    @Override
    public void onPlayerJoin(String username) {
        this.computerQueueEvent(EVENT_JOIN, username);
    }

    @Override
    public void onPlayerLeave(String username) {
        this.computerQueueEvent(EVENT_LEAVE, username);
    }

    @Override
    public String getToken() {
        return COMMAND_TOKEN;
    }

    @Override
    public void onServerChatEvent(String message, EntityPlayer player) {
        this.computerQueueEvent(EVENT_COMMAND, player.getDisplayName(), message);
    }

    protected void computerQueueEvent(String event, Object ... args) {
        if (this.computers == null || this.computers.isEmpty()) {
            return;
        }
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent(event, ArrayUtils.add((Object[])args, (int)0, (Object)computer.getAttachmentName()));
        }
    }

    private void unload() {
        if (!this.field_145850_b.field_72995_K) {
            ChatBoxHandler.instance.removeChatListener(this);
            ChatBoxHandler.instance.removeDeathListener(this);
            ChatBoxHandler.instance.removeCommandListener(this);
            ChatBoxHandler.instance.removePlayerEventListener(this);
        }
    }

    private String buildMessage(String msg, boolean pm) {
        return "[" + (this.label.isEmpty() ? "ChatBox" : this.label) + (ConfigHandler.displayChatBoxCoords ? String.format(" (%d,%d,%d)", this.field_145851_c, this.field_145848_d, this.field_145849_e) : "") + "] " + (pm ? "[PM] " : "") + msg;
    }
}

