/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.tile;

import com.google.common.collect.Maps;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.LuaPeripheral;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.LuaFunction;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.MultiReturn;
import com.theoriginalbit.moarperipherals.api.tile.IHasGui;
import com.theoriginalbit.moarperipherals.client.gui.GuiType;
import com.theoriginalbit.moarperipherals.common.reference.Constants;
import com.theoriginalbit.moarperipherals.common.tile.abstracts.TileInventory;
import com.theoriginalbit.moarperipherals.common.utils.InventoryUtils;
import dan200.computercraft.api.lua.LuaException;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

@LuaPeripheral(value="computer_crafter")
public class TileComputerCrafter
extends TileInventory
implements IHasGui {
    public InventoryCrafting craftingInv = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer player) {
            return true;
        }
    }, 3, 3);
    final CraftingManager manager = CraftingManager.func_77594_a();

    public TileComputerCrafter() {
        super(18);
    }

    @Override
    public String func_145825_b() {
        return Constants.GUI.CRAFTER.getLocalised();
    }

    @LuaFunction
    public int getInventorySize() {
        return this.func_70302_i_();
    }

    @LuaFunction(value="getStackInSlot")
    public ItemStack stackInSlot(int slot) {
        if (--slot >= 0 || slot <= this.func_70302_i_()) {
            return this.func_70301_a(slot);
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        InventoryUtils.readInventoryFromNBT((IInventory)this.craftingInv, tag.func_150295_c("craft", 10));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74782_a("craft", (NBTBase)InventoryUtils.writeInventoryToNBT((IInventory)this.craftingInv));
    }

    @Override
    public GuiType getGuiId() {
        return GuiType.CRAFTER;
    }

    @LuaFunction
    public boolean isRecipeValid() {
        return this.manager.func_82787_a(this.craftingInv, this.field_145850_b) != null;
    }

    @LuaFunction
    public ItemStack getCraftingSlot(int slot) throws LuaException {
        if (--slot >= 0 || slot <= this.craftingInv.func_70302_i_()) {
            return this.craftingInv.func_70301_a(slot);
        }
        return null;
    }

    @LuaFunction
    @MultiReturn
    public Object[] setCraftingSlot(int slot, ItemStack stack) {
        if (--slot < 0 || slot > this.craftingInv.func_70302_i_()) {
            return new Object[]{false, "expected slot between 1 and " + this.craftingInv.func_70302_i_()};
        }
        stack.field_77994_a = 1;
        this.craftingInv.func_70299_a(slot, stack);
        return new Object[]{true};
    }

    @LuaFunction
    public Object[] clearCraftingSlot(int slot) {
        if (--slot < 0 || slot > this.craftingInv.func_70302_i_()) {
            return new Object[]{false, "expected slot between 1 and " + this.craftingInv.func_70302_i_()};
        }
        this.craftingInv.func_70299_a(slot, null);
        return new Object[]{true};
    }

    @LuaFunction
    public void clearCraftingGrid() {
        for (int i = 0; i < this.craftingInv.func_70302_i_(); ++i) {
            this.craftingInv.func_70299_a(i, null);
        }
    }

    @LuaFunction
    @MultiReturn
    public Object[] craft() {
        try {
            this.doCraft();
            return new Object[]{true};
        }
        catch (Exception e) {
            return new Object[]{false, e.getMessage()};
        }
    }

    public void doCraft() throws Exception {
        Class<?> itemClass;
        ItemStack itemStack;
        int slot;
        ItemStack result = this.manager.func_82787_a(this.craftingInv, this.field_145850_b);
        if (result == null) {
            throw new Exception("invalid recipe");
        }
        HashMap counts = Maps.newHashMap();
        for (slot = 0; slot < this.craftingInv.func_70302_i_(); ++slot) {
            itemStack = this.craftingInv.func_70301_a(slot);
            if (itemStack == null) continue;
            itemClass = itemStack.func_77973_b().getClass();
            if (!counts.containsKey(itemClass)) {
                counts.put(itemClass, 0);
            }
            counts.put(itemClass, (Integer)counts.get(itemClass) + 1);
        }
        for (slot = 0; slot < this.craftingInv.func_70302_i_(); ++slot) {
            itemStack = this.craftingInv.func_70301_a(slot);
            if (itemStack == null) continue;
            itemClass = itemStack.func_77973_b().getClass();
            if (InventoryUtils.findQtyOf((IInventory)this, itemStack) >= (Integer)counts.get(itemClass)) continue;
            throw new Exception("cannot craft, missing items");
        }
        for (slot = 0; slot < this.craftingInv.func_70302_i_(); ++slot) {
            itemStack = this.craftingInv.func_70301_a(slot);
            if (itemStack == null) continue;
            InventoryUtils.takeItems((IInventory)this, itemStack, 1);
        }
        InventoryUtils.storeOrDropItemStack((IInventory)this, result, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

