/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.tile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.Computers;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.LuaPeripheral;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.LuaFunction;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.MultiReturn;
import com.theoriginalbit.moarperipherals.api.tile.aware.IActivateAwareTile;
import com.theoriginalbit.moarperipherals.api.tile.aware.IBreakAwareTile;
import com.theoriginalbit.moarperipherals.common.mount.MountMoarP;
import com.theoriginalbit.moarperipherals.common.reference.Constants;
import com.theoriginalbit.moarperipherals.common.tile.abstracts.TileInventory;
import com.theoriginalbit.moarperipherals.common.tile.firework.LauncherTube;
import com.theoriginalbit.moarperipherals.common.tile.firework.QueueBuffer;
import com.theoriginalbit.moarperipherals.common.utils.InventoryUtils;
import dan200.computercraft.api.lua.LuaException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemFirework;
import net.minecraft.item.ItemFireworkCharge;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;

@LuaPeripheral(value="firework_launcher")
@Computers.Mount(value={MountMoarP.class})
public class TileFireworks
extends TileInventory
implements IActivateAwareTile,
IBreakAwareTile {
    private static final ImmutableList<ItemStack> ITEM_SHAPES = ImmutableList.of((Object)new ItemStack(Items.field_151059_bz), (Object)new ItemStack(Items.field_151074_bl), (Object)new ItemStack(Items.field_151144_bL), (Object)new ItemStack(Items.field_151008_G));
    private static final ItemStack GLOWSTONE = new ItemStack(Items.field_151114_aO);
    private static final ItemStack GUNPOWDER = new ItemStack(Items.field_151016_H);
    private static final ItemStack DIAMOND = new ItemStack(Items.field_151045_i);
    private static final ItemStack PAPER = new ItemStack(Items.field_151121_aF);
    private static final int MAX_SLOTS = 9;
    protected final QueueBuffer bufferRocket = new QueueBuffer("Rocket", 90);
    protected final QueueBuffer bufferStar = new QueueBuffer("Star", 90);
    private final LauncherTube[] fireworkTubes = new LauncherTube[9];
    final CraftingManager manager = CraftingManager.func_77594_a();

    public TileFireworks() {
        this(54);
    }

    protected TileFireworks(int invSize) {
        super(invSize);
        for (int i = 0; i < this.fireworkTubes.length; ++i) {
            this.fireworkTubes[i] = new LauncherTube(this.bufferRocket, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_145845_h() {
        LauncherTube[] launcherTubeArray = this.fireworkTubes;
        synchronized (this.fireworkTubes) {
            for (LauncherTube tube : this.fireworkTubes) {
                tube.update();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String func_145825_b() {
        return Constants.GUI.FIREWORKS.getLocalised();
    }

    @Override
    public boolean onActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!this.isCreativeLauncher()) {
            player.func_71007_a((IInventory)this);
            return true;
        }
        return false;
    }

    @Override
    public void onBreak(int x, int y, int z) {
        this.bufferRocket.explodeBuffer(this.field_145850_b, x, y, z);
        this.bufferStar.explodeBuffer(this.field_145850_b, x, y, z);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.bufferRocket.readFromNBT(tag);
        this.bufferStar.readFromNBT(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.bufferRocket.writeToNBT(tag);
        this.bufferStar.writeToNBT(tag);
    }

    @LuaFunction(value="getStackInSlot")
    public ItemStack stackInSlot(int slot) {
        if (--slot >= 0 && slot < this.func_70302_i_()) {
            return this.func_70301_a(slot);
        }
        return null;
    }

    @LuaFunction
    public int getInventorySize() {
        return this.func_70302_i_();
    }

    @LuaFunction
    public boolean isCreativeLauncher() {
        return false;
    }

    @LuaFunction
    @MultiReturn
    public Object[] load(int slot) {
        if (--slot < 0 || slot > this.func_70302_i_()) {
            return new Object[]{false, "slot out of range, should be 1-" + this.func_70302_i_()};
        }
        ItemStack stack = this.func_70301_a(slot);
        if (stack == null) {
            return new Object[]{false, "nothing in slot"};
        }
        Item item = stack.func_77973_b();
        QueueBuffer buffer = null;
        if (item instanceof ItemFirework) {
            buffer = this.bufferRocket;
        }
        if (item instanceof ItemFireworkCharge) {
            buffer = this.bufferStar;
        }
        if (buffer == null) {
            return new Object[]{false, "item in slot is not a Firework Rocket or Firework Star"};
        }
        if (stack.field_77994_a == 1) {
            this.func_70299_a(slot, null);
        }
        return new Object[]{true, buffer.addItemStack(stack.func_77979_a(1))};
    }

    @LuaFunction
    @MultiReturn
    public Object[] craftFireworkStar(int color, int shape, int modifier) {
        ArrayList<Integer> colors;
        if (!TileFireworks.validColor(color, true)) {
            return new Object[]{false, "invalid color colour provided"};
        }
        if (shape < 0 || shape > 4) {
            return new Object[]{false, "shape should be 0 to 4"};
        }
        if (modifier < 0 || modifier > 3) {
            return new Object[]{false, "modifier should be 0 to 3"};
        }
        int remaining = 8;
        boolean shouldTwinkle = false;
        boolean shouldTrail = false;
        boolean hasShape = false;
        if (this.findQtyOf(GUNPOWDER) == 0) {
            return new Object[]{false, "cannot create firework star, no gunpowder"};
        }
        if (shape != 0) {
            if (--shape == 2) {
                boolean found = false;
                for (Head head : Head.values()) {
                    if (this.findQtyOf(head.getItemStack()) <= 0) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return new Object[]{false, "cannot create firework star, no mob head found"};
                }
            } else {
                ItemStack stack = (ItemStack)ITEM_SHAPES.get(shape);
                if (this.findQtyOf(stack) == 0) {
                    return new Object[]{false, "cannot create firework star, no " + stack.func_82833_r() + " found"};
                }
            }
            hasShape = true;
            --remaining;
        }
        if (modifier != 0) {
            shouldTwinkle = modifier == 1 || modifier == 3;
            boolean bl = shouldTrail = modifier == 2 || modifier == 3;
            if (shouldTwinkle) {
                if (this.findQtyOf(GLOWSTONE) == 0) {
                    return new Object[]{false, "cannot create firework star, no glowstone"};
                }
                --remaining;
            }
            if (shouldTrail) {
                if (this.findQtyOf(DIAMOND) == 0) {
                    return new Object[]{false, "cannot create firework star, no diamond"};
                }
                --remaining;
            }
        }
        if ((colors = TileFireworks.explodeColor(color)).size() > remaining) {
            return new Object[]{false, "too many items to craft firework star"};
        }
        ArrayList dyes = Lists.newArrayList();
        for (int i : colors) {
            ItemStack stack = TileFireworks.colorToDye(i);
            dyes.add(stack);
            if (this.findQtyOf(stack) != 0) continue;
            return new Object[]{false, "cannot create firework star, no " + stack.func_82833_r()};
        }
        ArrayList items = Lists.newArrayList((Object[])new ItemStack[]{this.extract(GUNPOWDER)});
        if (shouldTwinkle) {
            items.add(this.extract(GLOWSTONE));
        }
        if (shouldTrail) {
            items.add(this.extract(DIAMOND));
        }
        if (hasShape) {
            if (shape == 2) {
                for (Head head : Head.values()) {
                    ItemStack s = this.extract(head.getItemStack());
                    if (s == null || s.field_77994_a <= 0) continue;
                    items.add(s);
                    break;
                }
            } else {
                items.add(this.extract((ItemStack)ITEM_SHAPES.get(shape)));
            }
        }
        for (ItemStack dye : dyes) {
            items.add(this.extract(dye));
        }
        InventoryCrafting crafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return true;
            }
        }, items.size() + 1, 1);
        for (int i = 0; i < items.size(); ++i) {
            crafting.func_70299_a(i, (ItemStack)items.get(i));
        }
        ItemStack result = this.manager.func_82787_a(crafting, this.field_145850_b);
        if (result == null) {
            return new Object[]{false, "we have the resources, but crafting failed"};
        }
        return new Object[]{true, this.bufferStar.addItemStack(result)};
    }

    @LuaFunction
    @MultiReturn
    public Object[] craftFireworkRocket(int height, List<Double> starIds) {
        if (!this.bufferRocket.hasFreeSpace()) {
            return new Object[]{false, "no free space in the rocket launch buffer"};
        }
        if (height < 1 || height > 3) {
            return new Object[]{false, "rocket height should be between 1 and 3"};
        }
        if (this.findQtyOf(PAPER) == 0) {
            return new Object[]{false, "cannot create firework, no paper"};
        }
        int qty = this.findQtyOf(GUNPOWDER);
        if (qty < height) {
            return new Object[]{false, "cannot create firework, missing " + (height - qty) + " gunpowder"};
        }
        if (starIds.size() > 9 - height - 1) {
            return new Object[]{false, "cannot craft, too many firework stars"};
        }
        for (Double id : starIds) {
            int rId = id.intValue();
            if (this.bufferStar.containsItemStackWithId(rId)) continue;
            return new Object[]{false, "cannot craft, no firework rocket with ID " + rId};
        }
        ArrayList items = Lists.newArrayList();
        items.add(this.extract(PAPER));
        for (int i = 0; i < height; ++i) {
            items.add(this.extract(GUNPOWDER));
        }
        for (Double id : starIds) {
            items.add(this.bufferStar.getItemStackWithId(id.intValue()));
        }
        InventoryCrafting crafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return true;
            }
        }, items.size() + 1, 1);
        for (int i = 0; i < items.size(); ++i) {
            crafting.func_70299_a(i, (ItemStack)items.get(i));
        }
        ItemStack result = this.manager.func_82787_a(crafting, this.field_145850_b);
        if (result == null) {
            return new Object[]{false, "we have the resources, but crafting failed"};
        }
        return new Object[]{true, this.bufferRocket.addItemStack(result)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    @MultiReturn
    public Object[] launch() {
        LauncherTube[] launcherTubeArray = this.fireworkTubes;
        synchronized (this.fireworkTubes) {
            for (LauncherTube tube : this.fireworkTubes) {
                if (!tube.canLaunch()) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return tube.launch(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new Object[]{false, "Cannot launch rocket, rockets currently reloading"};
        }
    }

    @LuaFunction
    @MultiReturn
    public Object[] unloadFireworkRocket(int id) {
        if (!this.bufferRocket.containsItemStackWithId(id)) {
            return new Object[]{"No Firework Rocket with that ID found"};
        }
        this.bufferRocket.insertOrExplode((IInventory)this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, id);
        return new Object[]{true};
    }

    @LuaFunction
    @MultiReturn
    public Object[] unloadFireworkStar(int id) {
        if (!this.bufferStar.containsItemStackWithId(id)) {
            return new Object[]{"No Firework Star with that ID found"};
        }
        this.bufferStar.insertOrExplode((IInventory)this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, id);
        return new Object[]{true};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public boolean canLaunch() {
        if (this.bufferRocket.getCurrentSize() == 0) {
            return false;
        }
        LauncherTube[] launcherTubeArray = this.fireworkTubes;
        synchronized (this.fireworkTubes) {
            for (LauncherTube tube : this.fireworkTubes) {
                if (!tube.canLaunch()) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    @LuaFunction
    public ArrayList<Integer> getFireworkStarIds() {
        return this.bufferStar.getWrapperIds();
    }

    @LuaFunction
    public ArrayList<Integer> getFireworkRocketIds() {
        return this.bufferRocket.getWrapperIds();
    }

    @LuaFunction
    public ArrayList<String> inspectFireworkRocket(int id) throws LuaException {
        if (!this.bufferRocket.containsItemStackWithId(id)) {
            throw new LuaException("No Firework Rocket with that ID found");
        }
        return TileFireworks.getDescription(this.bufferRocket, id);
    }

    @LuaFunction
    public ArrayList<String> inspectFireworkStar(int id) throws LuaException {
        if (!this.bufferStar.containsItemStackWithId(id)) {
            throw new LuaException("No Firework Star with that ID found");
        }
        return TileFireworks.getDescription(this.bufferStar, id);
    }

    private static ArrayList<Integer> explodeColor(int color) {
        ArrayList colors = Lists.newArrayList();
        for (int i = 0; i < 16; ++i) {
            if (!TileFireworks.test(color, (int)Math.pow(2.0, i))) continue;
            colors.add(i);
        }
        return colors;
    }

    protected int findQtyOf(ItemStack stack) {
        return this.isCreativeLauncher() ? 64 : InventoryUtils.findQtyOf((IInventory)this, stack);
    }

    protected ItemStack extract(ItemStack stack) {
        if (this.isCreativeLauncher()) {
            ItemStack s = stack.func_77946_l();
            s.field_77994_a = 1;
            return s;
        }
        return InventoryUtils.takeItems((IInventory)this, stack, 1);
    }

    private static boolean test(int colors, int color) {
        return (colors & color) == color;
    }

    private static boolean validColor(int color, boolean multi) {
        if (color < 1 || multi && color > 65535 || !multi && color > 32768) {
            return false;
        }
        if (multi) {
            return true;
        }
        double val = Math.log(color) / Math.log(2.0);
        return val >= 0.0 && val <= 15.0 && val % 1.0 == 0.0;
    }

    private static ItemStack colorToDye(int color) {
        return new ItemStack(Items.field_151100_aR, 1, 15 - color);
    }

    private static ArrayList<String> getDescription(QueueBuffer buffer, int id) throws LuaException {
        ArrayList info = Lists.newArrayList();
        TileFireworks.addInformation(buffer.peekItemStackWithId(id), info);
        return info;
    }

    private static void addInformation(ItemStack stack, ArrayList<String> list) {
        if (!stack.func_77942_o()) {
            return;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemFirework) {
            TileFireworks.addFireworkRocketInfo(stack.func_77978_p().func_74775_l("Fireworks"), list);
        } else if (item instanceof ItemFireworkCharge) {
            TileFireworks.addFireworkChargeInfo(stack.func_77978_p().func_74775_l("Explosion"), list);
        }
    }

    private static void addFireworkRocketInfo(NBTTagCompound tag, ArrayList<String> list) {
        NBTTagList nbttaglist;
        if (tag.func_150297_b("Flight", 99)) {
            list.add(StatCollector.func_74838_a((String)"item.fireworks.flight") + " " + tag.func_74771_c("Flight"));
        }
        if ((nbttaglist = tag.func_150295_c("Explosions", 10)) != null && nbttaglist.func_74745_c() > 0) {
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound compound = nbttaglist.func_150305_b(i);
                ArrayList other = Lists.newArrayList();
                TileFireworks.addFireworkChargeInfo(compound, other);
                if (other.size() <= 0) continue;
                for (int j = 1; j < other.size(); ++j) {
                    other.set(j, other.get(j));
                }
                list.addAll(other);
            }
        }
    }

    private static void addFireworkChargeInfo(NBTTagCompound tag, ArrayList<String> list) {
        boolean flag3;
        boolean flag2;
        int[] aint2;
        byte b0 = tag.func_74771_c("Type");
        if (b0 >= 0 && b0 <= 4) {
            list.add(StatCollector.func_74838_a((String)("item.fireworksCharge.type." + b0)).trim());
        } else {
            list.add(StatCollector.func_74838_a((String)"item.fireworksCharge.type").trim());
        }
        int[] aInt = tag.func_74759_k("Colors");
        if (aInt.length > 0) {
            boolean flag = true;
            String s = "";
            for (int k : aInt) {
                if (!flag) {
                    s = s + ", ";
                }
                flag = false;
                boolean flag1 = false;
                for (int l = 0; l < 16; ++l) {
                    if (k != ItemDye.field_150922_c[l]) continue;
                    flag1 = true;
                    s = s + StatCollector.func_74838_a((String)("item.fireworksCharge." + ItemDye.field_150923_a[l]));
                    break;
                }
                if (flag1) continue;
                s = s + StatCollector.func_74838_a((String)"item.fireworksCharge.customColor");
            }
            list.add(s);
        }
        if ((aint2 = tag.func_74759_k("FadeColors")).length > 0) {
            boolean flag22 = true;
            String s1 = StatCollector.func_74838_a((String)"item.fireworksCharge.fadeTo") + " ";
            for (int j1 : aint2) {
                if (!flag22) {
                    s1 = s1 + ", ";
                }
                flag22 = false;
                boolean flag4 = false;
                for (int i1 = 0; i1 < 16; ++i1) {
                    if (j1 != ItemDye.field_150922_c[i1]) continue;
                    flag4 = true;
                    s1 = s1 + StatCollector.func_74838_a((String)("item.fireworksCharge." + ItemDye.field_150923_a[i1]));
                    break;
                }
                if (flag4) continue;
                s1 = s1 + StatCollector.func_74838_a((String)"item.fireworksCharge.customColor");
            }
            list.add(s1);
        }
        if (flag2 = tag.func_74767_n("Trail")) {
            list.add(StatCollector.func_74838_a((String)"item.fireworksCharge.trail"));
        }
        if (flag3 = tag.func_74767_n("Flicker")) {
            list.add(StatCollector.func_74838_a((String)"item.fireworksCharge.flicker"));
        }
    }

    private static enum Head {
        SKELETON,
        WITHER,
        ZOMBIE,
        PLAYER,
        CREEPER;

        private final ItemStack itemStack = new ItemStack(Items.field_151144_bL, 1, this.ordinal());

        public ItemStack getItemStack() {
            return this.itemStack;
        }
    }
}

