/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.tile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.Computers;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.LuaPeripheral;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.LuaFunction;
import com.theoriginalbit.moarperipherals.common.config.ConfigHandler;
import com.theoriginalbit.moarperipherals.common.mount.MountMoarP;
import com.theoriginalbit.moarperipherals.common.network.PacketHandler;
import com.theoriginalbit.moarperipherals.common.network.message.MessageFxIronNote;
import com.theoriginalbit.moarperipherals.common.tile.abstracts.TileMoarP;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;

@LuaPeripheral(value="iron_note")
@Computers.Mount(value={MountMoarP.class})
public class TileIronNote
extends TileMoarP {
    private static ImmutableList<String> INSTRUMENTS = ImmutableList.of((Object)"harp", (Object)"bd", (Object)"snare", (Object)"hat", (Object)"bassattack");
    private static final int MIN_INST = 0;
    private static final int MAX_INST = 4;
    private static final int MIN_PITCH = 0;
    private static final int MAX_PITCH = 24;
    private static final int MAX_NOTES = 5;
    private int notesCount = 0;
    private MessageFxIronNote message;

    @LuaFunction
    public void playNote(int instrument, int pitch) throws Exception {
        Preconditions.checkArgument((instrument >= 0 && instrument <= 4 ? 1 : 0) != 0, (String)"Expected instrument %d-%d", (Object[])new Object[]{0, 4});
        Preconditions.checkArgument((pitch >= 0 && pitch <= 24 ? 1 : 0) != 0, (String)"Expected pitch %d-%d", (Object[])new Object[]{0, 24});
        Preconditions.checkArgument((this.notesCount++ < 5 ? 1 : 0) != 0, (String)"Too many notes (over %d per tick)", (Object[])new Object[]{5});
        Preconditions.checkArgument((ConfigHandler.noteRange > 0 ? 1 : 0) != 0, (Object)"The Iron Note blocks range has been disabled, please contact your server owner");
        if (this.message == null) {
            this.message = new MessageFxIronNote();
        }
        this.message.addNote("note." + (String)INSTRUMENTS.get(instrument), pitch);
    }

    public void func_145845_h() {
        this.notesCount = 0;
        if (this.message != null) {
            this.message.pack(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)this.message, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)ConfigHandler.noteRange));
            this.message = null;
        }
    }
}

