/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.tile;

import com.google.common.base.Strings;
import com.theoriginalbit.moarperipherals.api.tile.IPairedDevice;
import com.theoriginalbit.moarperipherals.api.tile.aware.IActivateAwareTile;
import com.theoriginalbit.moarperipherals.common.block.BlockKeyboardPc;
import com.theoriginalbit.moarperipherals.common.config.ConfigHandler;
import com.theoriginalbit.moarperipherals.common.reference.ModInfo;
import com.theoriginalbit.moarperipherals.common.tile.abstracts.TileMoarP;
import com.theoriginalbit.moarperipherals.common.utils.NBTUtils;
import com.theoriginalbit.moarperipherals.common.utils.PairedUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.ResourceLocation;

public class TileKeyboard
extends TileMoarP
implements IPairedDevice,
IActivateAwareTile {
    private int connectedInstanceId = -1;
    private String connectedInstanceDesc;
    private boolean connected;

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.configureTargetFromNbt(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("instanceId", this.connectedInstanceId);
        if (!Strings.isNullOrEmpty((String)this.connectedInstanceDesc)) {
            tag.func_74778_a("instanceDesc", this.connectedInstanceDesc);
        }
    }

    public void func_145845_h() {
        if (!this.connected) {
            this.connected = PairedUtils.isRegisteredInstance(this.connectedInstanceId);
        }
        if (this.connected && PairedUtils.isRegisteredInstance(this.connectedInstanceId)) {
            this.connectedInstanceDesc = PairedUtils.getDescription(this.connectedInstanceId);
        }
    }

    @Override
    public NBTTagCompound getDescriptionNBT() {
        NBTTagCompound tag = super.getDescriptionNBT();
        tag.func_74768_a("instanceId", this.connectedInstanceId);
        if (!Strings.isNullOrEmpty((String)this.connectedInstanceDesc)) {
            tag.func_74778_a("instanceDesc", this.connectedInstanceDesc);
        }
        return tag;
    }

    @Override
    protected void readDescriptionNBT(NBTTagCompound tag) {
        super.readDescriptionNBT(tag);
        this.configureTargetFromNbt(tag);
    }

    @Override
    public boolean onActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        PairedUtils.turnOn(PairedUtils.getInstance(this.connectedInstanceId));
        return true;
    }

    public final boolean hasConnection() {
        return this.connectedInstanceId > -1;
    }

    public final ResourceLocation getTextureForRender() {
        String state = this.hasConnection() && this.isTargetInRange() ? "On" : (this.hasConnection() && !this.isTargetInRange() ? "Lost" : "Off");
        int meta = this.func_145838_q() instanceof BlockKeyboardPc ? 1 : 0;
        return new ResourceLocation(ModInfo.RESOURCE_DOMAIN, String.format("textures/models/blocks/keyboard/Keyboard_%d_%s.png", meta, state));
    }

    @Override
    public final boolean configureTargetFromNbt(NBTTagCompound tag) {
        this.connectedInstanceId = tag.func_74762_e("instanceId");
        if (tag.func_74764_b("instanceDesc")) {
            this.connectedInstanceDesc = tag.func_74779_i("instanceDesc");
        }
        return true;
    }

    @Override
    public ItemStack getPairedDrop() {
        ItemStack stack = new ItemStack(this.func_145838_q(), 1);
        if (this.connectedInstanceId > -1) {
            NBTUtils.setInteger(stack, "instanceId", this.connectedInstanceId);
        }
        return stack;
    }

    public final void terminateTarget() {
        if (this.isTargetInRange()) {
            PairedUtils.terminate(PairedUtils.getInstance(this.connectedInstanceId));
        }
    }

    public final void rebootTarget() {
        if (this.isTargetInRange()) {
            PairedUtils.reboot(PairedUtils.getInstance(this.connectedInstanceId));
        }
    }

    public final void shutdownTarget() {
        if (this.isTargetInRange()) {
            PairedUtils.shutdown(PairedUtils.getInstance(this.connectedInstanceId));
        }
    }

    public final void queueEventToTarget(String event, Object ... args) {
        if (this.isTargetInRange()) {
            PairedUtils.queueEvent(PairedUtils.getInstance(this.connectedInstanceId), event, args);
        }
    }

    public boolean isTargetInRange() {
        ChunkCoordinates coord = new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return PairedUtils.isRegisteredInstance(this.connectedInstanceId) && PairedUtils.distanceToComputer(this.connectedInstanceId, coord) <= (float)ConfigHandler.keyboardRange;
    }
}

