/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.tile;

import com.google.common.collect.Lists;
import com.theoriginalbit.moarperipherals.api.bitnet.BitNetMessage;
import com.theoriginalbit.moarperipherals.api.bitnet.IBitNetCompliant;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.Computers;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.LuaPeripheral;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.LuaFunction;
import com.theoriginalbit.moarperipherals.common.config.ConfigHandler;
import com.theoriginalbit.moarperipherals.common.registry.BitNetRegistry;
import com.theoriginalbit.moarperipherals.common.tile.abstracts.TileMoarP;
import com.theoriginalbit.moarperipherals.common.utils.LogUtils;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@LuaPeripheral(value="bitnet_antenna")
public class TileMiniAntenna
extends TileMoarP
implements IBitNetCompliant {
    private static final String EVENT_BITNET = "bitnet_message";
    private static final float ROTATION_SPEED = 1.0f;
    private static final float BOB_MULTIPLIER = 0.02f;
    private static final float BOB_SPEED = 16.0f;
    private final ArrayList<UUID> receivedMessages = Lists.newArrayList();
    private boolean registered = false;
    private float rotation = 0.0f;
    private float bob = 0.0f;
    private int tick = 0;
    @Computers.List
    public ArrayList<IComputerAccess> computers;

    public float getRotation() {
        return this.rotation;
    }

    public float getBob() {
        return this.bob;
    }

    public void func_145845_h() {
        if (!this.registered) {
            this.registerTower();
        }
        this.rotation = (this.rotation + 1.0f) % 360.0f;
        this.bob = 0.02f * (float)Math.sin((float)(++this.tick) / 16.0f);
    }

    @LuaFunction
    public void transmit(Object payload) {
        BitNetRegistry.transmit(this, new BitNetMessage(payload));
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public Vec3 getWorldPosition() {
        return Vec3.func_72443_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    @Override
    public void receive(BitNetMessage payload) {
        if (!this.receivedMessages.contains(payload.getMessageId())) {
            if (this.computers != null && this.computers.size() > 0) {
                LogUtils.debug(String.format("BitNet Mini Antenna at %d %d %d has computer(s) connected, queueing BitNet message.", this.field_145851_c, this.field_145848_d, this.field_145849_e), new Object[0]);
                for (IComputerAccess comp : this.computers) {
                    comp.queueEvent(EVENT_BITNET, new Object[]{comp.getAttachmentName(), payload.getPayload(), payload.getDistanceTravelled()});
                }
            }
            this.receivedMessages.add(payload.getMessageId());
        } else {
            LogUtils.debug(String.format("BitNet Mini Antenna at %d %d %d received a previously received message.", this.field_145851_c, this.field_145848_d, this.field_145849_e), new Object[0]);
        }
    }

    @Override
    public int getReceiveRange() {
        return ConfigHandler.miniAntennaRange;
    }

    @Override
    public int getReceiveRangeDuringStorm() {
        return ConfigHandler.miniAntennaRangeStorm;
    }

    private void registerTower() {
        if (!this.field_145850_b.field_72995_K) {
            BitNetRegistry.registerCompliance(this);
        }
        this.registered = true;
    }
}

