/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.tile;

import com.theoriginalbit.moarperipherals.api.peripheral.annotation.LuaPeripheral;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.LuaFunction;
import com.theoriginalbit.moarperipherals.api.tile.IHasGui;
import com.theoriginalbit.moarperipherals.client.gui.GuiType;
import com.theoriginalbit.moarperipherals.common.reference.Constants;
import com.theoriginalbit.moarperipherals.common.tile.abstracts.TileInventory;
import com.theoriginalbit.moarperipherals.common.tile.printer.PaperState;
import com.theoriginalbit.moarperipherals.common.tile.printer.PrinterState;

@LuaPeripheral(value="advanced_printer")
public class TilePrinter
extends TileInventory
implements IHasGui {
    private static final int[] SLOTS_BOTTOM = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    private static final int[] SLOTS_SIDE = new int[]{14};
    private static final int[] SLOTS_TOP = new int[]{0, 1, 2, 3};

    public TilePrinter() {
        super(15);
    }

    public PrinterState getPrinterState() {
        return PrinterState.IDLE;
    }

    public PaperState getPaperState() {
        if (this.hasPaperInput() && this.hasPaperOutput()) {
            return PaperState.PAPER_BOTH;
        }
        if (this.hasPaperInput()) {
            return PaperState.PAPER_INPUT;
        }
        if (this.hasPaperOutput()) {
            return PaperState.PAPER_OUTPUT;
        }
        return PaperState.PAPER_NONE;
    }

    @LuaFunction(value="hasPaper")
    public boolean hasPaperInput() {
        return true;
    }

    private boolean hasPaperOutput() {
        return true;
    }

    @Override
    public GuiType getGuiId() {
        return GuiType.PRINTER;
    }

    @Override
    public String func_145825_b() {
        return Constants.GUI.PRINTER.getLocalised();
    }

    @Override
    public int func_70297_j_() {
        return 16;
    }

    @Override
    public int[] func_94128_d(int side) {
        switch (side) {
            case 0: {
                return SLOTS_BOTTOM;
            }
            case 1: {
                return SLOTS_TOP;
            }
        }
        return SLOTS_SIDE;
    }
}

