/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.tile;

import com.theoriginalbit.moarperipherals.api.peripheral.annotation.LuaPeripheral;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.LuaFunction;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.MultiReturn;
import com.theoriginalbit.moarperipherals.common.config.ConfigHandler;
import com.theoriginalbit.moarperipherals.common.network.PacketHandler;
import com.theoriginalbit.moarperipherals.common.network.message.MessageFxTeleport;
import com.theoriginalbit.moarperipherals.common.tile.abstracts.TileMoarP;
import com.theoriginalbit.moarperipherals.common.utils.TurtleUtils;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dan200.computercraft.api.turtle.ITurtleAccess;
import net.minecraft.util.ChunkCoordinates;

@LuaPeripheral(value="turtle_teleport")
public class TileTurtleTeleport
extends TileMoarP {
    @LuaFunction
    @MultiReturn
    public Object[] getTurtleLocation() {
        ITurtleAccess turtle = TurtleUtils.getITurtle(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (turtle != null) {
            ChunkCoordinates coords = turtle.getPosition();
            return new Object[]{true, new Integer[]{coords.field_71574_a, coords.field_71572_b, coords.field_71573_c}};
        }
        return new Object[]{false, "No Turtle found above the teleport"};
    }

    @LuaFunction
    @MultiReturn
    public Object[] teleportTo(int x, int y, int z) {
        ITurtleAccess turtle = TurtleUtils.getITurtle(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (turtle != null) {
            if (!this.field_145850_b.func_147437_c(x, y, z)) {
                return new Object[]{false, "Teleport failed"};
            }
            int requiredFuel = this.requiredFuelInternal(turtle, x, y, z);
            if (requiredFuel > turtle.getFuelLevel()) {
                return new Object[]{false, "Not enough fuel"};
            }
            turtle.consumeFuel(requiredFuel);
            turtle.teleportTo(this.field_145850_b, x, y, z);
            this.doTeleportFX(new ChunkCoordinates(x, y, z));
            return new Object[]{true};
        }
        return new Object[]{false, "No Turtle found above the teleport"};
    }

    @LuaFunction
    public int requiredFuel(int x, int y, int z) {
        ITurtleAccess turtle = TurtleUtils.getITurtle(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        return this.requiredFuelInternal(turtle, x, y, z);
    }

    private int requiredFuelInternal(ITurtleAccess turtle, int x, int y, int z) {
        if (turtle == null) {
            return 0;
        }
        ChunkCoordinates coords = turtle.getPosition();
        double distance = Math.sqrt(coords.func_71569_e(x, y, z));
        return (int)Math.ceil(distance * ConfigHandler.fuelMultiplier);
    }

    private void doTeleportFX(ChunkCoordinates target) {
        if (!this.field_145850_b.field_72995_K) {
            int dimId = this.field_145850_b.field_73011_w.field_76574_g;
            MessageFxTeleport sourceMessage = new MessageFxTeleport(dimId, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            MessageFxTeleport targetMessage = new MessageFxTeleport(dimId, target.field_71574_a, target.field_71572_b, target.field_71573_c);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)sourceMessage, new NetworkRegistry.TargetPoint(dimId, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, 64.0));
            PacketHandler.INSTANCE.sendToAllAround((IMessage)targetMessage, new NetworkRegistry.TargetPoint(dimId, (double)target.field_71574_a, (double)target.field_71572_b, (double)target.field_71573_c, 64.0));
        }
    }
}

