/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.tile.firework;

import com.google.common.collect.ImmutableList;
import com.theoriginalbit.moarperipherals.common.handler.TickHandler;
import com.theoriginalbit.moarperipherals.common.tile.firework.QueueBuffer;
import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LauncherTube {
    private static final ImmutableList<Double> OFFSETS = ImmutableList.of((Object)0.15, (Object)0.5, (Object)0.85);
    private static final int TICKS_COOL_DOWN = 20;
    private final QueueBuffer rocketBuffer;
    private int tick = 0;
    private final double xOffset;
    private final double yOffset;
    private final double zOffset;
    private boolean coolDownActive;

    public LauncherTube(QueueBuffer buffer, int position) {
        this.rocketBuffer = buffer;
        this.xOffset = (Double)OFFSETS.get(position % 3);
        this.yOffset = 0.8;
        this.zOffset = (Double)OFFSETS.get((int)Math.ceil(position / 3));
    }

    public void update() {
        if (this.coolDownActive && ++this.tick >= 20) {
            this.tick = 0;
            this.coolDownActive = false;
        }
    }

    public boolean canLaunch() {
        return !this.coolDownActive;
    }

    public Object[] launch(final World world, double x, double y, double z) {
        ItemStack firework = this.rocketBuffer.getNextItemStack();
        if (firework != null) {
            final EntityFireworkRocket rocket = new EntityFireworkRocket(world, x + this.xOffset, y + this.yOffset, z + this.zOffset, firework);
            TickHandler.addTickCallback(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    world.func_72838_d((Entity)rocket);
                    LauncherTube.this.coolDownActive = true;
                    return null;
                }
            });
            return new Object[]{true};
        }
        return new Object[]{false, "no firework to launch"};
    }
}

