/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.tile.firework;

import com.google.common.collect.Lists;
import com.theoriginalbit.moarperipherals.common.tile.firework.ItemStackWrapper;
import com.theoriginalbit.moarperipherals.common.utils.InventoryUtils;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class QueueBuffer {
    private final int maxSize;
    private final String invName;
    private final ArrayList<ItemStackWrapper> inventory;

    public QueueBuffer(String name, int size) {
        this.inventory = Lists.newArrayListWithCapacity((int)size);
        this.invName = name;
        this.maxSize = size;
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("BufferInv" + this.invName, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound itemTag = list.func_150305_b(i);
            this.addItemStack(ItemStack.func_77949_a((NBTTagCompound)itemTag));
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (ItemStackWrapper wrapper : this.inventory) {
            NBTTagCompound itemTag = wrapper.getItemStack().func_77955_b(new NBTTagCompound());
            list.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("BufferInv" + this.invName, (NBTBase)list);
    }

    public int getSizeInventory() {
        return this.maxSize;
    }

    public int getCurrentSize() {
        return this.inventory.size();
    }

    public void clear() {
        this.inventory.clear();
    }

    public long addItemStack(ItemStack stack) {
        if (this.inventory.size() < this.maxSize) {
            ItemStackWrapper wrapper = new ItemStackWrapper(stack.func_77979_a(1));
            this.inventory.add(wrapper);
            return wrapper.getId();
        }
        return -1L;
    }

    public ArrayList<Integer> getWrapperIds() {
        ArrayList result = Lists.newArrayList();
        for (ItemStackWrapper wrapper : this.inventory) {
            result.add(wrapper.getId());
        }
        return result;
    }

    public ItemStack getNextItemStack() {
        return this.inventory.size() > 0 ? this.inventory.remove(0).getItemStack() : null;
    }

    public boolean containsItemStackWithId(int id) {
        for (ItemStackWrapper wrapper : this.inventory) {
            if (wrapper == null || wrapper.getId() != id) continue;
            return true;
        }
        return false;
    }

    public ItemStack peekItemStackWithId(int id) {
        for (ItemStackWrapper wrapper : this.inventory) {
            if (wrapper.getId() != id) continue;
            return wrapper.getItemStack();
        }
        return null;
    }

    public ItemStack getItemStackWithId(int id) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStackWrapper wrapper = this.inventory.get(i);
            if (wrapper == null || wrapper.getId() != id) continue;
            this.inventory.remove(i);
            return wrapper.getItemStack();
        }
        return null;
    }

    public boolean hasFreeSpace() {
        return this.getCurrentSize() < this.getSizeInventory();
    }

    public void insertOrExplode(IInventory inv, World world, int x, int y, int z, int id) {
        InventoryUtils.storeOrDropItemStack(inv, this.getItemStackWithId(id), world, x, y, z);
    }

    public void explodeBuffer(World world, int x, int y, int z) {
        for (ItemStackWrapper item : this.inventory) {
            InventoryUtils.spawnItemStackInWorld(item.getItemStack(), world, x, y, z);
        }
    }
}

