/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.upgrade.peripheral;

import com.google.common.collect.Maps;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.LuaPeripheral;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.LuaFunction;
import com.theoriginalbit.moarperipherals.common.config.ConfigHandler;
import com.theoriginalbit.moarperipherals.common.network.PacketHandler;
import com.theoriginalbit.moarperipherals.common.network.message.MessageFxOreScanner;
import com.theoriginalbit.moarperipherals.common.utils.LogUtils;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

@LuaPeripheral(value="ore_scanner")
public class PeripheralDensityScanner {
    private static final HashMap<Block, Float> DENSITIES = Maps.newHashMap();
    private static final int SCAN_DIAMETER = 5;
    private static final int MAX_DEPTH = 40;
    private final ITurtleAccess turtle;

    public PeripheralDensityScanner(ITurtleAccess access) {
        this.turtle = access;
    }

    @LuaFunction
    public float getDensity() throws LuaException {
        World world = this.turtle.getWorld();
        ChunkCoordinates coords = this.turtle.getPosition();
        int x = coords.field_71574_a;
        int y = coords.field_71572_b;
        int z = coords.field_71573_c;
        Block blockBelow = world.func_147439_a(x, y - 1, z);
        if (blockBelow.func_149688_o() == Material.field_151579_a) {
            throw new LuaException("Turtle not on the ground");
        }
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageFxOreScanner(world.field_73011_w.field_76574_g, x, y, z), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 64.0));
        int radius = (int)Math.floor(2.0);
        int maxX = x + radius;
        int minX = x - radius;
        int maxY = y - 1;
        int minY = Math.max(maxY - 40, 0);
        int maxZ = z + radius;
        int minZ = z - radius;
        float density = 0.0f;
        for (int xPos = minX; xPos <= maxX; ++xPos) {
            for (int zPos = minZ; zPos <= maxZ; ++zPos) {
                for (int yPos = minY; yPos <= maxY; ++yPos) {
                    Block block = world.func_147439_a(xPos, yPos, zPos);
                    density += DENSITIES.containsKey(block) ? DENSITIES.get(block).floatValue() : 0.5f;
                }
            }
        }
        return density;
    }

    public static void addDensityMapping(String modid, String blockName, float density) {
        Block block = GameRegistry.findBlock((String)modid, (String)blockName);
        if (block == null) {
            LogUtils.warn(String.format("cannot find block %s:%s to apply a density mapping, skipping", modid, blockName), new Object[0]);
            return;
        }
        PeripheralDensityScanner.addDensityMapping(block, density);
    }

    public static void addDensityMapping(Block block, float density) {
        if (DENSITIES.containsKey(block)) {
            LogUtils.info("density mapping already exists for %s, skipping", block.func_149739_a());
            return;
        }
        if (density < 0.0f) {
            LogUtils.warn("density for %s was negative, changing to 0", block.func_149739_a());
        }
        LogUtils.info("added density mapping; " + block.func_149739_a(), new Object[0]);
        DENSITIES.put(block, Float.valueOf(Math.max(density, 0.0f)));
    }

    static {
        DENSITIES.put(Blocks.field_150348_b, Float.valueOf(0.29f));
        DENSITIES.put((Block)Blocks.field_150349_c, Float.valueOf(0.12f));
        DENSITIES.put(Blocks.field_150346_d, Float.valueOf(0.12f));
        DENSITIES.put(Blocks.field_150355_j, Float.valueOf(0.99f));
        DENSITIES.put((Block)Blocks.field_150358_i, Float.valueOf(0.99f));
        DENSITIES.put(Blocks.field_150353_l, Float.valueOf(2.72f));
        DENSITIES.put((Block)Blocks.field_150356_k, Float.valueOf(2.72f));
        DENSITIES.put((Block)Blocks.field_150354_m, Float.valueOf(0.15f));
        DENSITIES.put(Blocks.field_150351_n, Float.valueOf(0.16f));
        DENSITIES.put(Blocks.field_150352_o, Float.valueOf(19.3f));
        DENSITIES.put(Blocks.field_150366_p, Float.valueOf(7.87f));
        DENSITIES.put(Blocks.field_150365_q, Float.valueOf(1.25f));
        DENSITIES.put(Blocks.field_150364_r, Float.valueOf(0.72f));
        DENSITIES.put(Blocks.field_150363_s, Float.valueOf(0.72f));
        DENSITIES.put(Blocks.field_150369_x, Float.valueOf(2.8f));
        DENSITIES.put(Blocks.field_150322_A, Float.valueOf(0.25f));
        DENSITIES.put(Blocks.field_150321_G, Float.valueOf(1.31f));
        DENSITIES.put(Blocks.field_150343_Z, Float.valueOf(2.6f));
        DENSITIES.put(Blocks.field_150482_ag, Float.valueOf(3.51f));
        DENSITIES.put(Blocks.field_150450_ax, Float.valueOf(5.2f));
        DENSITIES.put(Blocks.field_150439_ay, Float.valueOf(5.2f));
        DENSITIES.put(Blocks.field_150432_aD, Float.valueOf(0.92f));
        DENSITIES.put(Blocks.field_150435_aG, Float.valueOf(0.16f));
        DENSITIES.put(Blocks.field_150424_aL, Float.valueOf(0.2f));
        DENSITIES.put(Blocks.field_150425_aM, Float.valueOf(0.16f));
        DENSITIES.put((Block)Blocks.field_150391_bh, Float.valueOf(0.12f));
        DENSITIES.put(Blocks.field_150412_bA, Float.valueOf(2.73f));
        DENSITIES.put(Blocks.field_150449_bY, Float.valueOf(2.65f));
        DENSITIES.put(Blocks.field_150403_cj, Float.valueOf(0.94f));
        if (ConfigHandler.enableUpgradeOreScanner && !ConfigHandler.userDensityMappings.isEmpty()) {
            String[] mappings;
            for (String str : mappings = ConfigHandler.userDensityMappings.split(";")) {
                try {
                    String[] map = str.split("@");
                    String[] block = map[0].split(":");
                    float density = Float.parseFloat(map[1]);
                    PeripheralDensityScanner.addDensityMapping(block[0], block[1], density);
                }
                catch (NumberFormatException e) {
                    LogUtils.warn("invalid density mapping, cannot parse density float; " + str, new Object[0]);
                }
                catch (Exception e) {
                    LogUtils.warn("invalid density mapping, unable to add mapping; " + str, new Object[0]);
                    e.printStackTrace();
                }
            }
        } else {
            LogUtils.info("no custom density mappings in config", new Object[0]);
        }
    }
}

