/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.upgrade.peripheral;

import com.theoriginalbit.moarperipherals.api.peripheral.annotation.LuaPeripheral;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.LuaFunction;
import com.theoriginalbit.moarperipherals.common.config.ConfigHandler;
import com.theoriginalbit.moarperipherals.common.network.PacketHandler;
import com.theoriginalbit.moarperipherals.common.network.message.MessageFxSmelt;
import com.theoriginalbit.moarperipherals.common.utils.InventoryUtils;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@LuaPeripheral(value="furnace")
public class PeripheralFurnace {
    private static final int FURNACE_SLOT_INPUT = 0;
    private static final int FURNACE_SLOT_OUTPUT = 2;
    private final IInventory inv;
    private final ITurtleAccess turtle;
    private final boolean upgradeOnLeft;
    private final TileEntityFurnace furnace;

    public PeripheralFurnace(ITurtleAccess access, TurtleSide periphSide) {
        this.turtle = access;
        this.upgradeOnLeft = periphSide == TurtleSide.Left;
        this.inv = this.turtle.getInventory();
        this.furnace = new TileEntityFurnace();
    }

    @LuaFunction
    public Object[] smelt(int slot, int amount) {
        if (slot < 1 || slot > this.inv.func_70302_i_()) {
            return new Object[]{false, "slot number " + slot + " out of range"};
        }
        if (amount < 1 || amount > 64) {
            return new Object[]{false, "invalid amount, should be between 1 and 64"};
        }
        ItemStack input = this.inv.func_70301_a(slot + 1);
        if (input == null || input.field_77994_a == 0) {
            return new Object[]{false, "nothing to smelt"};
        }
        amount = Math.min(amount, input.field_77994_a);
        ItemStack furnaceInput = input.func_77946_l();
        furnaceInput.field_77994_a = amount;
        this.furnace.func_70299_a(0, furnaceInput);
        if (!this.canSmelt()) {
            return new Object[]{false, "item in slot number " + slot + " cannot be smelted"};
        }
        int fuelNeeded = amount * ConfigHandler.upgradeFurnaceFuelConsumption;
        if (this.turtle.isFuelNeeded() && this.turtle.getFuelLevel() < fuelNeeded) {
            return new Object[]{false, "not enough fuel to smelt", fuelNeeded - this.turtle.getFuelLevel()};
        }
        for (int i = 0; i < amount; ++i) {
            this.furnace.func_145949_j();
        }
        ItemStack result = this.furnace.func_70301_a(2);
        this.furnace.func_70299_a(2, null);
        if (!InventoryUtils.canStoreItem(this.inv, result)) {
            return new Object[]{false, "not enough space in inventory"};
        }
        input.field_77994_a -= amount;
        if (input.field_77994_a == 0) {
            this.inv.func_70299_a(slot, null);
        }
        this.turtle.consumeFuel(fuelNeeded);
        World world = this.turtle.getWorld();
        ChunkCoordinates position = this.turtle.getPosition();
        InventoryUtils.storeOrDropItemStack(this.inv, result, world, position);
        this.doSmeltFX(world, position, ForgeDirection.getOrientation((int)this.turtle.getDirection()));
        return new Object[]{true, amount};
    }

    private boolean canSmelt() {
        ItemStack input = this.furnace.func_70301_a(0);
        return input != null && FurnaceRecipes.func_77602_a().func_151395_a(input) != null;
    }

    private void doSmeltFX(World worldObj, ChunkCoordinates coords, ForgeDirection dir) {
        if (!worldObj.field_72995_K) {
            int dimId = worldObj.field_73011_w.field_76574_g;
            double x = (double)coords.field_71574_a + 0.5;
            double y = (double)coords.field_71572_b + 0.4;
            double z = (double)coords.field_71573_c + 0.5;
            switch (dir) {
                case NORTH: {
                    x += this.upgradeOnLeft ? -0.5 : 0.5;
                    break;
                }
                case SOUTH: {
                    x += this.upgradeOnLeft ? 0.5 : -0.5;
                    break;
                }
                case EAST: {
                    z += this.upgradeOnLeft ? -0.5 : 0.5;
                    break;
                }
                case WEST: {
                    z += this.upgradeOnLeft ? 0.5 : -0.5;
                }
            }
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageFxSmelt(dimId, x, y, z), new NetworkRegistry.TargetPoint(dimId, x, y, z, 64.0));
        }
    }
}

