/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.upgrade.peripheral;

import com.theoriginalbit.moarperipherals.api.peripheral.annotation.LuaPeripheral;
import com.theoriginalbit.moarperipherals.api.peripheral.annotation.function.LuaFunction;
import dan200.computercraft.api.turtle.ITurtleAccess;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

@LuaPeripheral(value="solar")
public class PeripheralSolar {
    private static final int TICK_ADD_FUEL = 100;
    private ITurtleAccess turtle;
    private boolean active;
    private int tick = 0;

    public PeripheralSolar(ITurtleAccess access) {
        this.turtle = access;
    }

    @LuaFunction
    public void turnOn() {
        this.active = true;
    }

    @LuaFunction
    public void turnOff() {
        this.active = false;
    }

    @LuaFunction
    public int getNaturalLightLevel() {
        World world = this.turtle.getWorld();
        ChunkCoordinates coordinates = this.turtle.getPosition();
        int light = world.func_72972_b(EnumSkyBlock.Sky, coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c) - world.field_73008_k;
        float angle = world.func_72929_e(1.0f);
        angle = angle < (float)Math.PI ? (angle += (0.0f - angle) * 0.2f) : (angle += ((float)Math.PI * 2 - angle) * 0.2f);
        return Math.round((float)light * MathHelper.func_76134_b((float)angle));
    }

    public void update() {
        if (!this.active) {
            return;
        }
        World world = this.turtle.getWorld();
        if (!world.field_73011_w.field_76576_e && !world.field_72995_K && this.turtleNeedsFuel() && ++this.tick > 100) {
            ChunkCoordinates coordinates = this.turtle.getPosition();
            if (!world.func_72937_j(coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c)) {
                return;
            }
            int light = this.getNaturalLightLevel();
            if (light > 7) {
                this.turtle.addFuel(1);
            }
            this.tick = 0;
        }
    }

    private boolean turtleNeedsFuel() {
        return this.turtle.isFuelNeeded() && this.turtle.getFuelLevel() < this.turtle.getFuelLimit();
    }
}

