/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.utils;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public final class InventoryUtils {
    private static final Random rand = new Random();

    public static boolean areItemsStackable(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        if (a == b) {
            return true;
        }
        if (a.func_77973_b() == b.func_77973_b() && (!a.func_77981_g() && !a.func_77984_f() || a.func_77960_j() == b.func_77960_j())) {
            if (a.field_77990_d == null && b.field_77990_d == null) {
                return true;
            }
            if (a.field_77990_d != null && b.field_77990_d != null && a.field_77990_d.equals((Object)b.field_77990_d)) {
                return true;
            }
        }
        return false;
    }

    public static boolean canStoreItem(IInventory inv, ItemStack stack) {
        int count = stack.field_77994_a;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack contents = inv.func_70301_a(slot);
            if (contents == null) {
                return true;
            }
            if (!InventoryUtils.areItemsStackable(contents, stack)) continue;
            int space = Math.min(contents.func_77976_d(), inv.func_70297_j_()) - contents.field_77994_a;
            if (space >= count) {
                return true;
            }
            if (space <= 0) continue;
            count -= space;
        }
        return count == 0;
    }

    public static void storeOrDropItemStack(IInventory inv, ItemStack stack, World world, ChunkCoordinates coords) {
        InventoryUtils.storeOrDropItemStack(inv, stack, world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
    }

    public static void storeOrDropItemStack(IInventory inv, ItemStack stack, World world, int x, int y, int z) {
        ItemStack remainder = InventoryUtils.storeItemStack(inv, stack);
        if (remainder != null && remainder.field_77994_a > 0) {
            InventoryUtils.spawnItemStackInWorld(stack, world, x, y, z);
        }
    }

    public static ItemStack storeItemStack(IInventory inv, ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return null;
        }
        ItemStack remainder = stack;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            int space;
            ItemStack contents = inv.func_70301_a(slot);
            if (contents == null) {
                space = inv.func_70297_j_();
                if (space >= remainder.field_77994_a) {
                    inv.func_70299_a(slot, remainder);
                    inv.func_70296_d();
                    return null;
                }
                remainder = remainder.func_77946_l();
                inv.func_70299_a(slot, remainder.func_77979_a(space));
                continue;
            }
            if (!InventoryUtils.areItemsStackable(contents, remainder)) continue;
            space = Math.min(contents.func_77976_d(), inv.func_70297_j_()) - contents.field_77994_a;
            if (space >= remainder.field_77994_a) {
                contents.field_77994_a += remainder.field_77994_a;
                inv.func_70299_a(slot, contents);
                inv.func_70296_d();
                return null;
            }
            if (space <= 0) continue;
            remainder = remainder.func_77946_l();
            remainder.field_77994_a -= space;
            contents.field_77994_a += space;
            inv.func_70299_a(slot, contents);
        }
        if (remainder != stack) {
            inv.func_70296_d();
        }
        return remainder;
    }

    public static ItemStack takeItems(IInventory inv, ItemStack stack, int amount) {
        if (stack == null || amount <= 0) {
            return null;
        }
        ItemStack partial = stack.func_77946_l();
        partial.field_77994_a = 0;
        int remaining = Math.min(amount, stack.func_77976_d());
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack contents;
            if (remaining <= 0 || (contents = inv.func_70301_a(slot)) == null || !InventoryUtils.areItemsStackable(contents, stack)) continue;
            if (contents.field_77994_a > remaining) {
                contents.field_77994_a -= remaining;
                partial.field_77994_a += remaining;
                remaining = 0;
            } else {
                partial.field_77994_a += contents.field_77994_a;
                contents.field_77994_a = 0;
                remaining = amount - partial.field_77994_a;
            }
            if (contents.field_77994_a != 0) continue;
            inv.func_70299_a(slot, null);
        }
        if (partial.field_77994_a > 0 && amount > 0) {
            inv.func_70296_d();
            return partial;
        }
        return null;
    }

    public static int[] makeSlotArray(IInventory inv) {
        int[] slots = new int[inv.func_70302_i_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public static void writeInventoryToNBT(IInventory inv, NBTTagCompound tag) {
        tag.func_74782_a("Items", (NBTBase)InventoryUtils.writeInventoryToNBT(inv));
    }

    public static NBTTagList writeInventoryToNBT(IInventory inv) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        return list;
    }

    public static void readInventoryFromNBT(IInventory inv, NBTTagCompound tag) {
        InventoryUtils.readInventoryFromNBT(inv, tag.func_150295_c("Items", 10));
    }

    public static void readInventoryFromNBT(IInventory inv, NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound itemTag = list.func_150305_b(i);
            int slot = itemTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= inv.func_70302_i_()) continue;
            inv.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)itemTag));
        }
    }

    public static int findQtyOf(IInventory inv, ItemStack stack) {
        int qty = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (!InventoryUtils.areItemsStackable(item, stack)) continue;
            qty += item.field_77994_a;
        }
        return qty;
    }

    public static void explodeInventory(IInventory inv, World world, int x, int y, int z) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            InventoryUtils.spawnItemStackInWorld(inv.func_70301_a(i), world, x, y, z);
        }
    }

    public static void spawnItemStackInWorld(ItemStack stack, World world, int x, int y, int z) {
        if (stack != null && stack.field_77994_a > 0) {
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(stack.func_77973_b(), stack.field_77994_a, stack.func_77960_j()));
            if (stack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            stack.field_77994_a = 0;
        }
    }
}

