/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.utils;

import com.google.common.base.Strings;
import com.theoriginalbit.moarperipherals.common.utils.ReflectionUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ModContainer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;

public final class PairedUtils {
    private static final Class<?> CLASS_COMPUTER_CMD = ReflectionUtils.getClass("dan200.computercraft.shared.computer.blocks.TileCommandComputer");
    private static final Class<?> CLASS_COMPUTER_BASE = ReflectionUtils.getClass("dan200.computercraft.shared.computer.blocks.TileComputerBase");
    private static final Class<?> CLASS_I_COMPUTER = ReflectionUtils.getClass("dan200.computercraft.shared.computer.core.IComputer");
    private static final Method METHOD_QUEUE_EVENT = ReflectionUtils.getMethod(CLASS_I_COMPUTER, "queueEvent", String.class, Object[].class);
    private static final Method METHOD_IS_ON = ReflectionUtils.getMethod(CLASS_I_COMPUTER, "isOn", new Class[0]);
    private static final Method METHOD_TURN_ON = ReflectionUtils.getMethod(CLASS_I_COMPUTER, "turnOn", new Class[0]);
    private static final Method METHOD_SHUTDOWN = ReflectionUtils.getMethod(CLASS_I_COMPUTER, "shutdown", new Class[0]);
    private static final Method METHOD_REBOOT = ReflectionUtils.getMethod(CLASS_I_COMPUTER, "reboot", new Class[0]);
    private static final String EVENT_TERMINATE = "terminate";
    private static Map<Integer, Object> computerRegistry = new HashMap<Integer, Object>();

    public static boolean isComputer(TileEntity tile) {
        if (tile == null) {
            return false;
        }
        Class<?> clazz = tile.getClass();
        return PairedUtils.instanceOf(clazz, CLASS_COMPUTER_BASE);
    }

    public static boolean isPairAllowed(TileEntity tile) {
        if (tile == null) {
            return false;
        }
        Class<?> clazz = tile.getClass();
        return PairedUtils.isComputer(tile) && !PairedUtils.instanceOf(clazz, CLASS_COMPUTER_CMD);
    }

    public static int getInstanceId(TileEntity tile) {
        if (tile == null) {
            return -1;
        }
        try {
            Field idField = CLASS_COMPUTER_BASE.getDeclaredField("m_instanceID");
            idField.setAccessible(true);
            int instanceId = (Integer)idField.get(tile);
            idField.setAccessible(false);
            return instanceId;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static Object getInstance(int instanceId) {
        if (!PairedUtils.isRegisteredInstance(instanceId)) {
            return null;
        }
        return computerRegistry.get(instanceId);
    }

    public static boolean isRegisteredInstance(int instanceId) {
        return computerRegistry.containsKey(instanceId);
    }

    public static ChunkCoordinates getInstanceLocation(int instanceId) {
        Object computer = PairedUtils.getInstance(instanceId);
        if (computer == null) {
            return null;
        }
        try {
            Field field = computer.getClass().getDeclaredField("m_position");
            field.setAccessible(true);
            return (ChunkCoordinates)field.get(computer);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void queueEvent(Object instance, String event, Object ... args) {
        if (instance == null || !CLASS_I_COMPUTER.isAssignableFrom(instance.getClass())) {
            return;
        }
        ReflectionUtils.callMethod(instance, METHOD_QUEUE_EVENT, event, args);
    }

    public static boolean isOn(Object instance) {
        if (instance == null || !CLASS_I_COMPUTER.isAssignableFrom(instance.getClass())) {
            return false;
        }
        return (Boolean)ReflectionUtils.callMethod(instance, METHOD_IS_ON, new Object[0]);
    }

    public static void turnOn(Object instance) {
        if (instance == null || !CLASS_I_COMPUTER.isAssignableFrom(instance.getClass())) {
            return;
        }
        ReflectionUtils.callMethod(instance, METHOD_TURN_ON, new Object[0]);
    }

    public static void shutdown(Object instance) {
        if (instance == null || !CLASS_I_COMPUTER.isAssignableFrom(instance.getClass())) {
            return;
        }
        ReflectionUtils.callMethod(instance, METHOD_SHUTDOWN, new Object[0]);
    }

    public static void reboot(Object instance) {
        if (instance == null || !CLASS_I_COMPUTER.isAssignableFrom(instance.getClass())) {
            return;
        }
        ReflectionUtils.callMethod(instance, METHOD_REBOOT, new Object[0]);
    }

    public static void terminate(Object instance) {
        if (instance == null || !CLASS_I_COMPUTER.isAssignableFrom(instance.getClass())) {
            return;
        }
        PairedUtils.queueEvent(instance, EVENT_TERMINATE, new Object[0]);
    }

    public static float distanceToComputer(int instanceId, ChunkCoordinates origin) {
        ChunkCoordinates coordinates = PairedUtils.getInstanceLocation(instanceId);
        return coordinates != null ? MathHelper.func_76133_a((double)origin.func_82371_e(coordinates)) : 0.0f;
    }

    public static String getDescription(int instanceId) {
        if (!PairedUtils.isRegisteredInstance(instanceId)) {
            return "[missing]";
        }
        Object computer = computerRegistry.get(instanceId);
        try {
            Method getIdMethod = CLASS_I_COMPUTER.getMethod("getID", new Class[0]);
            Method getLabelMethod = CLASS_I_COMPUTER.getMethod("getLabel", new Class[0]);
            int id = (Integer)getIdMethod.invoke(computer, new Object[0]);
            String label = (String)getLabelMethod.invoke(computer, new Object[0]);
            if (Strings.isNullOrEmpty((String)label)) {
                return String.format("#%d", id);
            }
            return String.format("%s (#%d)", label, id);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return EnumChatFormatting.OBFUSCATED + "[error]";
        }
    }

    private static boolean instanceOf(Class<?> tile, Class<?> other) {
        return other != null && other.isAssignableFrom(tile);
    }

    static {
        try {
            Class<?> computerCraft = ReflectionUtils.getClass("dan200.computercraft.ComputerCraft");
            Field registryField = computerCraft.getDeclaredField("serverComputerRegistry");
            ModContainer container = FMLCommonHandler.instance().findContainerFor((Object)"ComputerCraft");
            Object registryObject = registryField.get(container);
            Field computerField = registryObject.getClass().getSuperclass().getDeclaredField("m_computers");
            computerField.setAccessible(true);
            computerRegistry = (Map)computerField.get(registryObject);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

